#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <gdk/gdk.h>
#include <libhildondesktop/libhildondesktop.h>
#include "system_info.h"

HD_DEFINE_PLUGIN_MODULE (SystemInfoWidget, system_info_widget, HD_TYPE_HOME_PLUGIN_ITEM)

static gint get_used_memory(){
    char buffer[128];
    FILE *file;
    int used = 0;
    int total = 0;
    int cached = 0;
    int buffers = 0;
    int free = 0;

    file = fopen("/proc/meminfo", "r");
    if(file == NULL){
        g_warning("Can't open file /proc/meminfo");
        return -1;
    }
    while(fgets(buffer, 128, file) != NULL){
        if(strncmp(buffer, "MemTotal", 8) == 0){
            sscanf(buffer + 10, "%d", &total);
        } else if(strncmp(buffer, "MemFree", 6) == 0){
            sscanf(buffer + 9, "%d", &free);
        } else if(strncmp(buffer, "Buffers", 6) == 0){
            sscanf(buffer + 9, "%d", &buffers);
        } else if(strncmp(buffer, "Cached", 6) == 0){
            sscanf(buffer + 8, "%d", &cached);
        }
    }
    fclose(file);

    used = total - free - cached - buffers;

    return used/1024;

}

static gint get_cpu_load(struct cpu_info *info){
    GError *error = NULL;
    gchar *contents;
    gsize length;

    if(!g_file_get_contents("/proc/stat", &contents, &length, &error)){
        fprintf(stderr, "ERR: can't read file %s: %s\n", "/proc/stat", error->message);
        g_error_free(error);
        return 0;
    }
    //g_printf(contents); 
    gchar **splits;
    splits = g_strsplit(contents, " ", -1);
    g_free(contents);

    gint user, nice, sys, idle;
    sscanf(splits[2], "%d", &user);
    sscanf(splits[3], "%d", &nice);
    sscanf(splits[4], "%d", &sys);
    sscanf(splits[5], "%d", &idle);

    gint time = (user - info->last_user) + (nice - info->last_nice) + (sys - info->last_sys);
    gint total_time = time + (idle - info->last_idle);

    info->last_user = user;
    info->last_nice = nice;
    info->last_sys = sys;
    info->last_idle = idle;

    return (100*time)/total_time;
    
}

static gboolean
update_stats(SystemInfoWidget *desktop_plugin){
    gchar temp[20];
    gint cpuload = get_cpu_load(&desktop_plugin->info);
//    g_print("CPU: %d \n", cpuload);
    g_sprintf(temp, "%d%%", cpuload);
    gtk_label_set_text(GTK_LABEL(desktop_plugin->cpu), temp);
    gint memused = get_used_memory();
    g_sprintf(temp, "%dMB", memused);
    gtk_label_set_text(GTK_LABEL(desktop_plugin->memory), temp);

}

static void
quit(SystemInfoWidget *desktop_plugin, gpointer data){
    g_source_remove(desktop_plugin->id);
}

static void
system_info_widget_init(SystemInfoWidget *desktop_plugin)
{
    g_signal_connect(GTK_OBJECT(desktop_plugin), "destroy", GTK_SIGNAL_FUNC(quit), NULL);
    gtk_widget_set_size_request(GTK_WIDGET(desktop_plugin), 167, 62);

//    GtkWidget *contents = build_ui();
    GtkVBox *vbox = GTK_VBOX(gtk_vbox_new(0, FALSE));
//    GtkLabel *label = GTK_LABEL(gtk_label_new("System Info widget"));
    GtkTable *table = gtk_table_new(2, 2, TRUE); 
    desktop_plugin->cpu = GTK_LABEL(gtk_label_new("0%"));
    desktop_plugin->memory = GTK_LABEL(gtk_label_new("0MB"));

//    gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(label), FALSE, FALSE, 0);
//    gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(desktop_plugin->cpu), FALSE, FALSE, 0);
//    gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(desktop_plugin->memory), FALSE, FALSE, 0);
    GtkImage *cpuimg = gtk_image_new_from_file("/opt/systeminfowidget/cpu.png");
    GtkImage *memimg = gtk_image_new_from_file("/opt/systeminfowidget/mem.png");
    gtk_table_attach_defaults(GTK_TABLE(table), GTK_WIDGET(cpuimg), 0, 1, 0, 1);
    gtk_table_attach_defaults(GTK_TABLE(table), GTK_WIDGET(memimg), 0, 1, 1, 2);
    gtk_table_attach_defaults(GTK_TABLE(table), GTK_WIDGET(desktop_plugin->cpu), 1, 2, 0, 1);
    gtk_table_attach_defaults(GTK_TABLE(table), GTK_WIDGET(desktop_plugin->memory), 1, 2, 1, 2);
    gtk_widget_show_all(GTK_WIDGET(table)); 
    desktop_plugin->id = gdk_threads_add_timeout(2000, update_stats, desktop_plugin);
    gtk_container_add(GTK_CONTAINER(desktop_plugin), GTK_WIDGET(table));
    gtk_window_set_opacity(GTK_WINDOW(desktop_plugin), 0.4);


}

static void
system_info_widget_realize(GtkWidget *widget){
    GdkScreen *screen = gtk_widget_get_screen(widget);
    gtk_widget_set_colormap(widget, gdk_screen_get_rgba_colormap(screen));
    gtk_widget_set_app_paintable(widget, TRUE);
    GTK_WIDGET_CLASS (system_info_widget_parent_class)->realize (widget);
}

static gboolean
system_info_widget_expose_event(GtkWidget *widget, GdkEventExpose *event){
    cairo_t *cr;
    cr = gdk_cairo_create(GDK_DRAWABLE(widget->window));
    gdk_cairo_region(cr, event->region);
    cairo_clip(cr);
    GtkImage *bg;
    bg = gtk_image_new_from_file("/opt/systeminfowidget/bg.png");
    cairo_set_operator(cr, CAIRO_OPERATOR_SOURCE);
    GdkPixbuf *pb = gtk_image_get_pixbuf(GTK_IMAGE(bg));
    gdk_cairo_set_source_pixbuf(cr, pb, 0, 0); 
//    cairo_set_source_rgba(cr, 0.0, 0.0, 0.0, 0.7);
    cairo_paint(cr);
    cairo_destroy(cr);

    return GTK_WIDGET_CLASS (system_info_widget_parent_class)->expose_event (widget, event);

}

static void
system_info_widget_class_init(SystemInfoWidgetClass *class){
    GtkWidgetClass *widget_class = GTK_WIDGET_CLASS(class);

    widget_class->realize = system_info_widget_realize;
    widget_class->expose_event = system_info_widget_expose_event;
}

static void
system_info_widget_class_finalize(SystemInfoWidgetClass *class){}
