#include "symfonieoptionsdialog.h"
#include "ui_symfonieoptionsdialog.h"
#include "mainwindow.h"
#include "symfoniedb.h"

SymfonieOptionsDialog::SymfonieOptionsDialog(MainWindow *parent) :
    QDialog(parent),
    ui(new Ui::SymfonieOptionsDialog)
{
    ui->setupUi(this);

    if(SymfonieDb::getInstance()->getSetting("is_show_main_toolbar", 1).toInt() == 1){
        this->ui->isShowToolbar->setChecked(true);
    }else{
        this->ui->isShowToolbar->setChecked(false);
    }


    if(SymfonieDb::getInstance()->getSetting("is_auto_resume_playback", 1).toInt() == 1){
        this->ui->isAutoResumePlayback->setChecked(true);
    }else{
        this->ui->isAutoResumePlayback->setChecked(false);
    }

    if(SymfonieDb::getInstance()->getSetting("is_continuously_play", 1).toInt() == 1){
        this->ui->isContinuouslyPlay->setChecked(true);
    }else{
        this->ui->isContinuouslyPlay->setChecked(false);
    }

    this->ui->playListFontSizeSb->setValue(SymfonieDb::getInstance()->getSetting("playlist_font_size", 14).toInt());


}

SymfonieOptionsDialog::~SymfonieOptionsDialog()
{
    delete ui;
}

void SymfonieOptionsDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


bool SymfonieOptionsDialog::getOptionIsShowToolbar(){
    return this->ui->isShowToolbar->isChecked();
}

bool SymfonieOptionsDialog::getOptionIsAutoResumePlayback(){
    return this->ui->isAutoResumePlayback->isChecked();
}

bool SymfonieOptionsDialog::getIsContinuouslyPlay(){
    return this->ui->isContinuouslyPlay->isChecked();
}


int SymfonieOptionsDialog::getPlayListFontSizeSbValue(){
    return this->ui->playListFontSizeSb->value();
}
