#include "swipecounter.h"
#include <QDebug>
#include <QPushButton>
#include <QDate>
SwipeCounter::SwipeCounter(){

    this->setFixedSize(200,100);
    if(set.value("reset_date",0)==0){
        set.setValue("reset_date",QDate::currentDate ());
    }
    swipes = set.value("swipes",0).toInt();
    dist = swipes*7.6;
    QVBoxLayout *lay  = new QVBoxLayout;
    conf = new GConfItem("/apps/osso/hildon-desktop/views/current");
    connect(conf,SIGNAL(valueChanged()),this,SLOT(desktopChanged()));
    count = new QLabel(this);
    count->setText("Swipes: " +QString::number(swipes));
    distance = new QLabel(this);
    if(dist < 100){
        distance->setText(QString::number(dist)+ " cm");
    }else{
        QString meters;
        distance->setText(meters.sprintf("%.2f",dist/100)+ " m");
    }
    lay->addWidget(count);
    lay->addWidget(distance);
    lay->setAlignment(Qt::AlignCenter);
    setLayout(lay);
    setAttribute(Qt::WA_TranslucentBackground);
}
void SwipeCounter::showSettingsDialog(){

    dialog = new QDialog();
    dialog->setWindowTitle("SwipeCounter");
    QLabel *label = new QLabel(dialog);
    label->setText("SwipeCounter v0.2  Sampo Savola 2010" );
    label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    QLabel *resetdate = new QLabel(dialog);
    resetdate->setText("Last reset: "+set.value("reset_date").toString());
    resetdate->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    reset = new QPushButton(dialog);
    reset->setText("Reset Counter");
    connect(reset,SIGNAL(clicked()),this,SLOT(resetCounter()));

    QVBoxLayout *lay = new QVBoxLayout(dialog);
    lay->addWidget(label);
    lay->addWidget(resetdate);
    lay->addWidget(reset);
    lay->setAlignment(Qt::AlignCenter);
    dialog->show();
}

void SwipeCounter::desktopChanged(){
    swipes = swipes+1;
    count->setText("Swipes: " + QString::number(swipes));
    dist = swipes*7.6;
    if(dist < 100){
        distance->setText(QString::number(dist) + " cm");
    }else
    {
        QString meters;
        distance->setText(meters.sprintf("%.2f",dist/100) + " m");
    }
    set.setValue("swipes",swipes);
}
void SwipeCounter::resetCounter(){

    set.setValue("swipes",0);
    swipes = 0;
    count->setText("Swipes: 0");
    distance->setText("0 cm");
    set.setValue("reset_date",QDate::currentDate ());
    reset->setDisabled(true);
    dialog->close();
}
