#!/usr/bin/python2.5

# Copyright (c) 2010 Christos Zamantzas
# Licenced under GPLv2

#################################################################
##  swappolube  -  Configuration UI for the swappolube script  ##
#################################################################

##Author: Christos Zamantzas <christos.zamantzas@gmail.com>
Version = '1.4-1'

import os
import sys
import time

import configCustom

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtMaemo5 import *
from swappolubeUI import *

##############################################################

PathTemp       = '/home/user/.swappolube'       # temp path of files
PathApp        = '/opt/swappolube'              # application path
PathSystem     = '/etc/event.d'                 # main path
ConfigTemp     = 'swappolube_config_temp'       # name of temp config file
ConfigCustom   = 'configCustom.py'              # name of custom config file
ConfigMain     = 'tuning'                       # tuning file
PathSystemUi   = '/etc/systemui'                # path to the storage of xml files for the power key menu
ConfigSystemUi = 'swappolube.xml'               # name of the apllications' xml file for the power key menu

##############################################################

def checkFile(Path, File):       
     ''' Check if a file exists. '''

     try:
         f = open(Path + "/" + File, 'r')
         f.close()
         return True
     except:
         return False

def checkMMC1():
     ''' Check if mmc1 installed. '''
    
     try:
         f = open('/sys/block/mmcblk1/queue/nr_requests', 'r')
         f.close()
         return True
     except:
         return False
        
def showMessage(message):        
     ''' Method to display a message to the user that waits for an action. '''

     os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications \
               org.freedesktop.Notifications.SystemNoteDialog \
               string:"%s" uint32:0 string:"OK"' % message)          

def showQuickMessage(message):   
     ''' Method to display shortly a message to the user. '''

     os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications \
               org.freedesktop.Notifications.SystemNoteInfoprint \
               string:"%s"' % message)          

def doUpdateConfig():            
     ''' Update the config file with the edited. '''

     time.sleep(1)
     try:
         os.system('sudo %s/updateSettings copyTuning_temp' % PathApp)
     except:
         return False
     else: 
         return True
       
class swappolubeAbout(QtGui.QMainWindow):
    '''About Window'''
    def __init__(self, parent=None):
        QMainWindow.__init__(self,parent)
        self.parent = parent
        self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
        self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
        self.setWindowTitle("Swappolube About")

        aboutScrollArea = QScrollArea(self)
        aboutScrollArea.setWidgetResizable(True)
        awidget = QWidget(aboutScrollArea)
        awidget.setMinimumSize(470,1000)
        awidget.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
        aboutScrollArea.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
        #Kinetic scroller is available on Maemo and should be on meego
        try:
             scroller = aboutScrollArea.property("kineticScroller").toPyObject()
             scroller.setEnabled(True)
        except:
             pass

        aboutLayout = QVBoxLayout(awidget)

        aboutIcon = QLabel()
        aboutIcon.setPixmap( QIcon.fromTheme('swappolube').pixmap(48,48) )
        aboutIcon.setAlignment( Qt.AlignCenter or Qt.AlignHCenter )
        aboutIcon.resize(128,128)
        aboutLayout.addWidget(aboutIcon)

        aboutLabel = QLabel('''<center><b>Swappolube</b> %s
                                   <br>
                                   <br>
                                   <b>The SWAPPOLUBE application is 
                                   <br>a user interface to the configuration 
                                   <br>of several parameters of the N900 kernel 
                                   <br>with the aim to make it faster.</b>
                                   <br>
                                   <br>Licenced under GPLv2
                                   <br>by <b>Christos Zamantzas</b> (Saturn)
                                   <br>
                                   <br>It provides the ability to change a number 
                                   <br>of parameters while in operation and 
                                   <br>if chosen can make them persistent  
                                   <br>by adding a script to event.d for them 
                                   <br>to be set after each boot.
                                   <br>
                                   <br>
                                   <b>Additional information on the usage, 
                                   <br>settings and implications can be found 
                                   <br>in the wiki page</b>
                                   <br>
                                   <br>
                                   <br><b>Thanks to :</b>
                                   <br><b>debernardis</b> at talk.maemo.org for
                                   <br>the name, icon and the application idea.
                                   <br>
                                   <br><b>Benoit HERVIER</b> at http://khertan.net/
                                   <br>for the code used in this about window.
                                   <br>
                                   </center>''' % Version)
        aboutLayout.addWidget(aboutLabel)
        self.bugtracker_button = QPushButton('BugTracker')
        self.bugtracker_button.clicked.connect(self.open_bugtracker)
        self.website_button = QPushButton('Wiki Page')
        self.website_button.clicked.connect(self.open_website)
        awidget2 = QWidget()
        buttonLayout = QHBoxLayout(awidget2)        
        buttonLayout.addWidget(self.bugtracker_button)
        buttonLayout.addWidget(self.website_button)
        aboutLayout.addWidget(awidget2)
        
        awidget.setLayout(aboutLayout)
        aboutScrollArea.setWidget(awidget)
        self.setCentralWidget(aboutScrollArea)
        self.show()        
        
    def open_website(self):
        QDesktopServices.openUrl(QUrl('http://wiki.maemo.org/Swappolube'))
    def open_bugtracker(self):
        QDesktopServices.openUrl(QUrl('https://bugs.maemo.org'))
        
class swappolubeMainWindow(QtGui.QMainWindow):
     def __init__(self, parent=None):
    
         ##Build parent user interface
         QtGui.QWidget.__init__(self, parent)
         self.ui = Ui_Swappolube()
         self.ui.setupUi(self)
         self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
         self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
         
         ##Connect the GUI Buttons with actions
           ##Create Settings
         QtCore.QObject.connect(self.ui.btnCreateConfig, QtCore.SIGNAL('clicked()'), self.doCreateConfig)
         QtCore.QObject.connect(self.ui.btnApplyConfig, QtCore.SIGNAL('clicked()'), self.doApplyConfig)
         QtCore.QObject.connect(self.ui.btnSetCurrent, QtCore.SIGNAL('clicked()'), self.doSetCurrent)
         QtCore.QObject.connect(self.ui.btnSetProposed, QtCore.SIGNAL('clicked()'), self.doSetProposed)
         QtCore.QObject.connect(self.ui.btnSetCustom, QtCore.SIGNAL('clicked()'), self.doSetCustom)
         QtCore.QObject.connect(self.ui.btnSaveCustom, QtCore.SIGNAL('clicked()'), self.doSaveCustom)
         
           ##Connect Menu Buttons 
         QtCore.QObject.connect(self.ui.actionQuit, QtCore.SIGNAL('triggered()'), QtGui.qApp, QtCore.SLOT('quit()'))
         QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.doAbout)
         QtCore.QObject.connect(self.ui.actionRestoreDefault, QtCore.SIGNAL('triggered()'), self.doRestoreDefault)
         QtCore.QObject.connect(self.ui.actionDeleteTuningFile, QtCore.SIGNAL('triggered()'), self.doDeleteTuningFile)
         QtCore.QObject.connect(self.ui.actionAddPowerKeyEntry, QtCore.SIGNAL('triggered()'), self.doAddPowerKeyEntry)
         QtCore.QObject.connect(self.ui.actionRemovePowerKeyEntry, QtCore.SIGNAL('triggered()'), self.doRemovePowerKeyEntry)
           ##Enable only the valid menu entry 
         if checkFile(PathSystem, ConfigMain) == False:
             self.ui.actionDeleteTuningFile.setEnabled(False)
           
         if checkFile(PathSystemUi, ConfigSystemUi) == True:
             self.ui.actionAddPowerKeyEntry.setEnabled(False)
         else:
             self.ui.actionRemovePowerKeyEntry.setEnabled(False)

         ##Set current values in the GUI
         self.doSetCurrent()

     ##Create Methods
            
     def doAbout(self):
         '''Open the about window.'''
         
         stackwindow = swappolubeAbout(self)
         stackwindow.show()

     def doAddPowerKeyEntry(self):
         '''Add entry in the Power Key menu'''
         
         os.system('sudo %s/updateSettings addPowerKeyEntry' % PathApp )
         self.ui.actionAddPowerKeyEntry.setEnabled(False)
         self.ui.actionRemovePowerKeyEntry.setEnabled(True)
         os.system('sudo %s/updateSettings updatePowerKeyEntry' % PathApp )
         message = 'Added entry in the Power Key Menu'
         showQuickMessage(message)

     def doRemovePowerKeyEntry(self):
         '''Remove entry from the Power Key menu'''

         os.system('sudo %s/updateSettings deletePowerKeyEntry' % PathApp )
         self.ui.actionAddPowerKeyEntry.setEnabled(True)
         self.ui.actionRemovePowerKeyEntry.setEnabled(False)
         os.system('sudo %s/updateSettings updatePowerKeyEntry' % PathApp )
         message = 'Removed entry from the Power Key Menu'
         showQuickMessage(message)
    
     def doDeleteTuningFile(self):
         '''Delete the tuning file'''
         
         os.system('sudo %s/updateSettings deleteTuning' % PathApp)
         if checkFile(PathSystem, ConfigMain) == True:
             message = 'The tuning file could not be deleted.\
                       \nPlease delete it manually.'
         else: 
             message = 'The tuning file has been removed from the boot sequence.\
                       \nOn next reboot, the system will start with its default configuration.'
         showMessage(message)
         self.ui.actionDeleteTuningFile.setEnabled(False)

     def doRestoreDefault(self): 
         ''' Apply the the default values.'''
         
         message = 'Please wait. Update in progress..'
         showQuickMessage(message)
         
         ##Update the values.
         os.system('sudo %s/updateSettings KillAllocatingTask 0' % PathApp )
         os.system('sudo %s/updateSettings PageCluster 5' % PathApp )
         os.system('sudo %s/updateSettings LaptopMode 0' % PathApp )
         os.system('sudo %s/updateSettings DirtyExpireCentisecs 500' % PathApp )
         os.system('sudo %s/updateSettings TCPTimestamps 1' % PathApp )
         os.system('sudo %s/updateSettings DirtyWritebackCentisecs 500' % PathApp )
         os.system('sudo %s/updateSettings TCPNoMetricsSave 0' % PathApp )
         os.system('sudo %s/updateSettings DirtyRatio 40' % PathApp )
         os.system('sudo %s/updateSettings Swappiness 100' % PathApp )
         os.system('sudo %s/updateSettings DirtyBGDRatio 10' % PathApp )
         os.system('sudo %s/updateSettings VFSCachePressure 100' % PathApp )
         #new options in ver. 1.1-1
         os.system('sudo %s/updateSettings mmc0requests 128' % PathApp )
         if checkMMC1() == True:
             os.system('sudo %s/updateSettings mmc1requests 128' % PathApp )
         os.system('sudo %s/updateSettings minFreekbytes 2039' % PathApp )
         
         if checkFile(PathSystem, ConfigMain) == True:
             message = 'The default values have been restored to the system.\n\nWARNING: A tuning file exists and will reapply its settings on the next reboot.'
         else:   
             message = 'The default values have been restored to the system.'
         showMessage(message)
         
         ##Set current values in the GUI
         self.doSetCurrent()
         
     def doSaveCustom(self):     
         ''' Save setting seen in the GUI as Custom Settings'''
         
         message = 'The custom settings are being saved please wait...'
         showQuickMessage(message)
         
         ##Read GUI.
         
         radioSwappiness              = '0'
         radioDirtyRatio              = '0'
         radioDirtyBGDRatio           = '0'
         radioDirtyExpireCentisecs    = '0'
         radioDirtyWritebackCentisecs = '0'
         radioPageCluster             = '0'
         radioVFSCachePressure        = '0'
         radioLaptopMode              = '0'
         radioKillAllocatingTask      = '0'
         radioTCPTimestamps           = '0'
         radioTCPNoMetricsSave        = '0'

         radiommc0requests            = '0'
         radiommc1requests            = '0'
         radioMinFreekbytes           = '0'

         if self.ui.radioSwappiness.isChecked() == True:
             radioSwappiness              = '1'
         if self.ui.radioDirtyRatio.isChecked() == True:
             radioDirtyRatio              = '1'
         if self.ui.radioDirtyBGDRatio.isChecked() == True:
             radioDirtyBGDRatio           = '1'
         if self.ui.radioDirtyExpireCentisecs.isChecked() == True:
             radioDirtyExpireCentisecs    = '1'
         if self.ui.radioDirtyWritebackCentisecs.isChecked() == True:
             radioDirtyWritebackCentisecs = '1'
         if self.ui.radioPageCluster.isChecked() == True:
             radioPageCluster             = '1'
         if self.ui.radioVFSCachePressure.isChecked() == True:
             radioVFSCachePressure        = '1'
         if self.ui.radioLaptopMode.isChecked() == True:
             radioLaptopMode              = '1'
         if self.ui.radioKillAllocatingTask.isChecked() == True:
             radioKillAllocatingTask      = '1'
         if self.ui.radioTCPTimestamps.isChecked() == True:
             radioTCPTimestamps           = '1'
         if self.ui.radioTCPNoMetricsSave.isChecked() == True:
             radioTCPNoMetricsSave        = '1'

         if self.ui.radiommc0requests.isChecked() == True:
             radiommc0requests        = '1'
         if self.ui.radiommc1requests.isChecked() == True:
             radiommc1requests        = '1'
         if self.ui.radioMinFreekbytes.isChecked() == True:
             radioMinFreekbytes        = '1'
         
         Swappiness                   = self.ui.lineSwappiness.text()
         DirtyRatio                   = self.ui.lineDirtyRatio.text()
         DirtyBGDRatio                = self.ui.lineDirtyBGDRatio.text()  
         DirtyExpireCentisecs         = self.ui.lineDirtyExpireCentisecs.text()
         DirtyWritebackCentisecs      = self.ui.lineDirtyWritebackCentisecs.text()
         PageCluster                  = self.ui.linePageCluster.text()
         VFSCachePressure             = self.ui.lineVFSCachePressure.text()
         LaptopMode                   = self.ui.lineLaptopMode.text()
         
         mmc0requests                 = self.ui.linemmc0requests.text()
         mmc1requests                 = self.ui.linemmc1requests.text()
         minFreekbytes                = self.ui.lineMinFreekbytes.text()
         
         if self.ui.checkBoxKillAllocatingTask.isChecked() == True:
             KillAllocatingTask = '1'
         else:
             KillAllocatingTask = '0'
         if self.ui.checkBoxTCPTimestamps.isChecked() == True:
             TCPTimestamps = '1'
         else:
             TCPTimestamps = '0'
         if self.ui.checkBoxTCPNoMetricsSave.isChecked() == True:
             TCPNoMetricsSave = '1'
         else:
             TCPNoMetricsSave = '0'   
            
         ##Write values to the custom file.
         
         try:
             os.system('echo "radioSwappiness = %s\
                         \nSwappiness = %s\
                         \nradioDirtyRatio = %s\
                         \nDirtyRatio = %s\
                         \nradioDirtyBGDRatio = %s\
                         \nDirtyBGDRatio = %s\
                         \nradioDirtyExpireCentisecs = %s\
                         \nDirtyExpireCentisecs = %s\
                         \nradioDirtyWritebackCentisecs = %s\
                         \nDirtyWritebackCentisecs = %s\
                         \nradioPageCluster = %s\
                         \nPageCluster = %s\
                         \nradioVFSCachePressure = %s\
                         \nVFSCachePressure = %s\
                         \nradioLaptopMode = %s\
                         \nLaptopMode = %s\
                         \nradioKillAllocatingTask = %s\
                         \nKillAllocatingTask = %s\
                         \nradioTCPTimestamps = %s\
                         \nTCPTimestamps = %s\
                         \nradioTCPNoMetricsSave = %s\
                         \nTCPNoMetricsSave = %s\
                         \nradiommc0requests = %s\
                         \nmmc0requests = %s\
                         \nradiommc1requests = %s\
                         \nmmc1requests = %s\
                         \nradioMinFreekbytes = %s\
                         \nminFreekbytes = %s" > %s/%s' % ( radioSwappiness, Swappiness, 
                                                            radioDirtyRatio,DirtyRatio,
                                                            radioDirtyBGDRatio, DirtyBGDRatio,
                                                            radioDirtyExpireCentisecs, DirtyExpireCentisecs,
                                                            radioDirtyWritebackCentisecs, DirtyWritebackCentisecs,
                                                            radioPageCluster, PageCluster,
                                                            radioVFSCachePressure, VFSCachePressure,
                                                            radioLaptopMode, LaptopMode,
                                                            radioKillAllocatingTask, KillAllocatingTask,
                                                            radioTCPTimestamps, TCPTimestamps,
                                                            radioTCPNoMetricsSave, TCPNoMetricsSave, 
                                                            radiommc0requests, mmc0requests,
                                                            radiommc1requests, mmc1requests, 
                                                            radioMinFreekbytes, minFreekbytes,
                                                            PathApp, ConfigCustom ) )

             message = 'The custom settings have been saved.'
             showMessage(message)             
         except:
             message = 'ERROR: The custom settings could not be saved.'
             showMessage(message)             
            
     def doSetCurrent(self):     
         ''' Set CURRENT values in the GUI''' ##FIXME: split reading and setting into seperate methods!!!
         
         ##Set values for enable/disable   
         self.ui.radioKillAllocatingTask.setChecked(False)
         self.ui.radioPageCluster.setChecked(False)
         self.ui.radioLaptopMode.setChecked(False)
         self.ui.radioDirtyExpireCentisecs.setChecked(False)
         self.ui.radioTCPTimestamps.setChecked(False)
         self.ui.radioDirtyWritebackCentisecs.setChecked(False)
         self.ui.radioTCPNoMetricsSave.setChecked(False)
         self.ui.radioVFSCachePressure.setChecked(False)
         self.ui.radioDirtyRatio.setChecked(False)
         self.ui.radioSwappiness.setChecked(False)
         self.ui.radioDirtyBGDRatio.setChecked(False)

         self.ui.radiommc0requests.setChecked(False)
         self.ui.radiommc1requests.setChecked(False)
         self.ui.radioMinFreekbytes.setChecked(False)

         ##Set Values for checkboxes
         
         if os.popen('cat /proc/sys/vm/oom_kill_allocating_task').read().strip('\n') == '1':
             self.ui.checkBoxKillAllocatingTask.setChecked(True)
         else:
             self.ui.checkBoxKillAllocatingTask.setChecked(False)

         if os.popen('cat /proc/sys/net/ipv4/tcp_timestamps').read().strip('\n') == '1':
             self.ui.checkBoxTCPTimestamps.setChecked(True)
         else:
             self.ui.checkBoxTCPTimestamps.setChecked(False)

         if os.popen('cat /proc/sys/net/ipv4/tcp_no_metrics_save').read().strip('\n') == '1':
             self.ui.checkBoxTCPNoMetricsSave.setChecked(True)
         else:
             self.ui.checkBoxTCPNoMetricsSave.setChecked(False)

         ##Set values for lineEdits
         LaptopMode = os.popen('cat /proc/sys/vm/laptop_mode').read().strip('\n')
         DirtyRatio = os.popen('cat /proc/sys/vm/dirty_ratio').read().strip('\n')
         Swappiness = os.popen('cat /proc/sys/vm/swappiness').read().strip('\n')
         DirtyBGDRatio = os.popen('cat /proc/sys/vm/dirty_background_ratio').read().strip('\n')
         readVFSCachePressure = os.popen('cat /proc/sys/vm/vfs_cache_pressure').read().strip('\n')
         PageCluster = os.popen('cat /proc/sys/vm/page-cluster').read().strip('\n')
         DirtyWritebackCentisecs = os.popen('cat /proc/sys/vm/dirty_writeback_centisecs').read().strip('\n')
         DirtyExpireCentisecs = os.popen('cat /proc/sys/vm/dirty_expire_centisecs').read().strip('\n')

         mmc0requests = os.popen('cat /sys/block/mmcblk0/queue/nr_requests').read().strip('\n')
         minFreekbytes = os.popen('cat /proc/sys/vm/min_free_kbytes').read().strip('\n')
         
         self.ui.lineLaptopMode.setText("%s" % LaptopMode)
         self.ui.lineDirtyRatio.setText("%s" % DirtyRatio)
         self.ui.lineSwappiness.setText("%s" % Swappiness)
         self.ui.lineDirtyBGDRatio.setText("%s" % DirtyBGDRatio)  
         self.ui.lineVFSCachePressure.setText("%s" % readVFSCachePressure)
         self.ui.linePageCluster.setText("%s" % PageCluster)
         self.ui.lineDirtyWritebackCentisecs.setText("%s" % DirtyWritebackCentisecs )
         self.ui.lineDirtyExpireCentisecs.setText("%s" % DirtyExpireCentisecs)

         self.ui.linemmc0requests.setText("%s" % mmc0requests)
         self.ui.lineMinFreekbytes.setText("%s" % minFreekbytes)
         
         if checkMMC1() == True:
             mmc1requests = os.popen('cat /sys/block/mmcblk1/queue/nr_requests').read().strip('\n')
             self.ui.linemmc1requests.setText("%s" % mmc1requests)
         else:
             self.ui.linemmc1requests.setText("128")
             self.ui.linemmc1requests.setEnabled(False)
             self.ui.radiommc1requests.setEnabled(False)
            
         message = 'The CURRENT configuration options are shown.'
         showQuickMessage(message)

     def doSetProposed(self):    
         ''' Set PROPOSED values in the GUI''' ##FIXME: outsource proposed values into a file!!!
         
         ##Set values for enable/disable   
         self.ui.radioKillAllocatingTask.setChecked(True)
         self.ui.radioPageCluster.setChecked(True)
         self.ui.radioLaptopMode.setChecked(True)
         self.ui.radioDirtyExpireCentisecs.setChecked(True)
         self.ui.radioTCPTimestamps.setChecked(True)
         self.ui.radioDirtyWritebackCentisecs.setChecked(True)
         self.ui.radioTCPNoMetricsSave.setChecked(True)
         self.ui.radioVFSCachePressure.setChecked(False)
         self.ui.radioDirtyRatio.setChecked(True)
         self.ui.radioSwappiness.setChecked(True)
         self.ui.radioDirtyBGDRatio.setChecked(True)

         self.ui.radiommc0requests.setChecked(False)
         self.ui.radiommc1requests.setChecked(False)
         self.ui.radioMinFreekbytes.setChecked(False)
         
         ##Set Values for checkboxes
         self.ui.checkBoxKillAllocatingTask.setChecked(True)
         self.ui.checkBoxTCPTimestamps.setChecked(False)
         self.ui.checkBoxTCPNoMetricsSave.setChecked(True)

         ##Set values for lineEdits
         self.ui.lineLaptopMode.setText("1")
         self.ui.lineDirtyRatio.setText("95")
         self.ui.lineSwappiness.setText("30")
         self.ui.lineDirtyBGDRatio.setText("60")  
         self.ui.lineVFSCachePressure.setText("100")
         self.ui.linePageCluster.setText("0")
         self.ui.lineDirtyWritebackCentisecs.setText("0")
         self.ui.lineDirtyExpireCentisecs.setText("0")

         self.ui.linemmc0requests.setText("128")
         self.ui.linemmc1requests.setText("128")
         self.ui.lineMinFreekbytes.setText("2039")

         message = 'The PROPOSED configuration options are shown.'
         showQuickMessage(message)

     def doSetCustom(self):      
         ''' Set CUSTOM values read from a file'''
         
         if checkFile(PathApp, ConfigCustom) == False:
            message = 'There is no custom file to be read.\
                       \nYou need to create first one..'
            showMessage(message)
         else: 
            message = 'The custom settings are being read please wait...'
            showQuickMessage(message)
            
            ##load user custom variables
            #import configCustom
            reload(configCustom)

            ##update the GUI
            
            #set first all checkboxes to False
            self.ui.radioKillAllocatingTask.setChecked(False)
            self.ui.radioPageCluster.setChecked(False)
            self.ui.radioLaptopMode.setChecked(False)
            self.ui.radioDirtyExpireCentisecs.setChecked(False)
            self.ui.radioTCPTimestamps.setChecked(False)
            self.ui.radioDirtyWritebackCentisecs.setChecked(False)
            self.ui.radioTCPNoMetricsSave.setChecked(False)
            self.ui.radioVFSCachePressure.setChecked(False)
            self.ui.radioDirtyRatio.setChecked(False)
            self.ui.radioSwappiness.setChecked(False)
            self.ui.radioDirtyBGDRatio.setChecked(False)

            self.ui.radiommc0requests.setChecked(False)
            self.ui.radiommc1requests.setChecked(False)
            self.ui.radioMinFreekbytes.setChecked(False)
            
            #now set those checkboxes=1 to True 
            if configCustom.radioSwappiness == 1:
                 self.ui.radioSwappiness.setChecked(True)
            if configCustom.radioDirtyRatio == 1:
                 self.ui.radioDirtyRatio.setChecked(True)
            if configCustom.radioDirtyBGDRatio == 1:
                 self.ui.radioDirtyBGDRatio.setChecked(True)
            if configCustom.radioDirtyExpireCentisecs == 1:
                 self.ui.radioDirtyExpireCentisecs.setChecked(True)
            if configCustom.radioDirtyWritebackCentisecs == 1:
                 self.ui.radioDirtyWritebackCentisecs.setChecked(True)
            if configCustom.radioPageCluster == 1:
                 self.ui.radioPageCluster.setChecked(True)
            if configCustom.radioVFSCachePressure == 1:
                 self.ui.radioVFSCachePressure.setChecked(True)
            if configCustom.radioLaptopMode == 1:
                 self.ui.radioLaptopMode.setChecked(True)
            if configCustom.radioKillAllocatingTask == 1:
                 self.ui.radioKillAllocatingTask.setChecked(True)
            if configCustom.radioTCPTimestamps == 1:
                 self.ui.radioTCPTimestamps.setChecked(True)
            if configCustom.radioTCPNoMetricsSave == 1:
                 self.ui.radioTCPNoMetricsSave.setChecked(True)                   

            if configCustom.radiommc0requests == 1:
                 self.ui.radiommc0requests.setChecked(True)
            if configCustom.radiommc1requests == 1:
                 self.ui.radiommc1requests.setChecked(True)
            if configCustom.radioMinFreekbytes == 1:
                 self.ui.radioMinFreekbytes.setChecked(True)
               
            if checkMMC1() == True:
                 self.ui.linemmc1requests.setText("%s" % configCustom.mmc1requests)
           
            self.ui.lineSwappiness.setText("%s" % configCustom.Swappiness)
            self.ui.lineDirtyRatio.setText("%s" % configCustom.DirtyRatio)
            self.ui.lineDirtyBGDRatio.setText("%s" % configCustom.DirtyBGDRatio )
            self.ui.lineDirtyExpireCentisecs.setText("%s" % configCustom.DirtyExpireCentisecs)
            self.ui.lineDirtyWritebackCentisecs.setText("%s" % configCustom.DirtyWritebackCentisecs)
            self.ui.linePageCluster.setText("%s" % configCustom.PageCluster)
            self.ui.lineVFSCachePressure.setText("%s" % configCustom.VFSCachePressure)
            self.ui.lineLaptopMode.setText("%s" % configCustom.LaptopMode)
            
            self.ui.linemmc0requests.setText("%s" % configCustom.mmc0requests)
            self.ui.lineMinFreekbytes.setText("%s" % configCustom.minFreekbytes)
            
            self.ui.checkBoxKillAllocatingTask.setChecked(False)
            self.ui.checkBoxTCPTimestamps.setChecked(False)
            self.ui.checkBoxTCPNoMetricsSave.setChecked(False)

            if configCustom.KillAllocatingTask == 1:
               self.ui.checkBoxKillAllocatingTask.setChecked(True)
            if configCustom.TCPTimestamps == 1:
               self.ui.checkBoxTCPTimestamps.setChecked(True)
            if configCustom.TCPNoMetricsSave == 1:
               self.ui.checkBoxTCPNoMetricsSave.setChecked(True)
               
            message = 'The CUSTOM configuration options are shown.'
            showQuickMessage(message)
         
     def doApplyConfig(self):    
         ''' Apply the configuration shown in the gui now! It will be lost on next reboot.'''
         
         message = 'Please wait. Update in progress..'
         showQuickMessage(message)
         
         ##Read GUI.
         DirtyRatio                 = self.ui.lineDirtyRatio.text()
         Swappiness                 = self.ui.lineSwappiness.text()
         DirtyBGDRatio              = self.ui.lineDirtyBGDRatio.text()  
         PageCluster                = self.ui.linePageCluster.text()
         DirtyExpireCentisecs       = self.ui.lineDirtyExpireCentisecs.text()
         DirtyWritebackCentisecs    = self.ui.lineDirtyWritebackCentisecs.text()
         LaptopMode                 = self.ui.lineLaptopMode.text()
         VFSCachePressure           = self.ui.lineVFSCachePressure.text()
         mmc0requests               = self.ui.linemmc0requests.text()
         mmc1requests               = self.ui.linemmc1requests.text()
         minFreekbytes              = self.ui.lineMinFreekbytes.text()
           
         if  self.ui.checkBoxKillAllocatingTask.isChecked() == True:
             KillAllocatingTask = '1'
         else:
             KillAllocatingTask = '0'
         if self.ui.checkBoxTCPTimestamps.isChecked() == True:
             TCPTimestamps = '1'
         else:
             TCPTimestamps = '0'
         if self.ui.checkBoxTCPNoMetricsSave.isChecked() == True:
             TCPNoMetricsSave = '1'
         else:
             TCPNoMetricsSave = '0'
          
         ##Update the values.
         if self.ui.radioKillAllocatingTask.isChecked() == True:
             os.system('sudo %s/updateSettings KillAllocatingTask %s' % (PathApp, KillAllocatingTask) )
         if self.ui.radioPageCluster.isChecked() == True:
             os.system('sudo %s/updateSettings PageCluster %s' % (PathApp, PageCluster) )
         if self.ui.radioLaptopMode.isChecked() == True:
             os.system('sudo %s/updateSettings LaptopMode %s' % (PathApp, LaptopMode) )
         if self.ui.radioDirtyExpireCentisecs.isChecked() == True:
             os.system('sudo %s/updateSettings DirtyExpireCentisecs %s' % (PathApp, DirtyExpireCentisecs) )
         if self.ui.radioTCPTimestamps.isChecked() == True:
             os.system('sudo %s/updateSettings TCPTimestamps %s' % (PathApp, TCPTimestamps) )
         if self.ui.radioDirtyWritebackCentisecs.isChecked() == True:
             os.system('sudo %s/updateSettings DirtyWritebackCentisecs %s' % (PathApp, DirtyWritebackCentisecs) )
         if self.ui.radioTCPNoMetricsSave.isChecked() == True:
             os.system('sudo %s/updateSettings TCPNoMetricsSave %s' % (PathApp, TCPNoMetricsSave) )
         if self.ui.radioDirtyRatio.isChecked() == True:
             os.system('sudo %s/updateSettings DirtyRatio %s' % (PathApp, DirtyRatio) )
         if self.ui.radioSwappiness.isChecked() == True:
             os.system('sudo %s/updateSettings Swappiness %s' % (PathApp, Swappiness) )
         if self.ui.radioDirtyBGDRatio.isChecked() == True:
             os.system('sudo %s/updateSettings DirtyBGDRatio %s' % (PathApp, DirtyBGDRatio) )
         if self.ui.radioVFSCachePressure.isChecked() == True:
             os.system('sudo %s/updateSettings VFSCachePressure %s' % (PathApp, VFSCachePressure) )

         if self.ui.radiommc0requests.isChecked() == True:
             os.system('sudo %s/updateSettings mmc0requests %s' % (PathApp, mmc0requests) )
         if self.ui.radiommc1requests.isChecked() == True:
             os.system('sudo %s/updateSettings mmc1requests %s' % (PathApp, mmc1requests) )
         if self.ui.radioMinFreekbytes.isChecked() == True:
             os.system('sudo %s/updateSettings minFreekbytes %s' % (PathApp, minFreekbytes) )
           
         message = 'The new values have been applied to the system.\n\nINFO:They will revert to their defaults on the next reboot.\
                    \nIf you want them to persist use the Store button.'
         showMessage(message)
         
     def doCreateConfig(self):   
         ''' Create the tuning file'''
         
         message = 'Please wait. Update in progress..'
         showQuickMessage(message)

         ##Read GUI.
         DirtyRatio                 = self.ui.lineDirtyRatio.text()
         Swappiness                 = self.ui.lineSwappiness.text()
         DirtyBGDRatio              = self.ui.lineDirtyBGDRatio.text()  
         PageCluster                = self.ui.linePageCluster.text()
         DirtyExpireCentisecs       = self.ui.lineDirtyExpireCentisecs.text()
         DirtyWritebackCentisecs    = self.ui.lineDirtyWritebackCentisecs.text()
         LaptopMode                 = self.ui.lineLaptopMode.text()
         VFSCachePressure           = self.ui.lineVFSCachePressure.text()

         mmc0requests               = self.ui.linemmc0requests.text()
         mmc1requests               = self.ui.linemmc1requests.text()
         minFreekbytes              = self.ui.lineMinFreekbytes.text()
           
         if  self.ui.checkBoxKillAllocatingTask.isChecked() == True:
             KillAllocatingTask = '1'
         else:
             KillAllocatingTask = '0'
         if self.ui.checkBoxTCPTimestamps.isChecked() == True:
             TCPTimestamps = '1'
         else:
             TCPTimestamps = '0'
         if self.ui.checkBoxTCPNoMetricsSave.isChecked() == True:
             TCPNoMetricsSave = '1'
         else:
             TCPNoMetricsSave = '0'
        
         ##Update of the config file.
         if checkFile(PathTemp, ConfigTemp) == True:
            try:
                 os.remove( PathTemp + "/" + ConfigTemp )
            except:
                 message = 'FATAL ERROR: The temp configuration file could not be removed.\nThe application will now exit..'
                 showMessage(message)
                 sys.exit(1)
            else:
                 pass 
         else:
             pass 

         destination = open( PathTemp + "/" + ConfigTemp, "w" )

         destination.write('description "N900 tuning"\n')
         destination.write('author "swappolube editor"\n')
         destination.write('\n')
         destination.write('\n')
         destination.write('console output\n')
         destination.write('\n')
         destination.write('start on started hildon-desktop\n')
         destination.write('\n')
         destination.write('\n')
         destination.write('script\n')
         if self.ui.radioKillAllocatingTask.isChecked() == True:
             destination.write('       echo "%s" > /proc/sys/vm/oom_kill_allocating_task\n' % KillAllocatingTask) 
         if self.ui.radioPageCluster.isChecked() == True:
             destination.write('       echo "%s" > /proc/sys/vm/page-cluster\n' % PageCluster) 
         if self.ui.radioLaptopMode.isChecked() == True:
             destination.write('       echo "%s" > /proc/sys/vm/laptop_mode\n' % LaptopMode) 
         if self.ui.radioDirtyExpireCentisecs.isChecked() == True:
             destination.write('       echo "%s" > /proc/sys/vm/dirty_expire_centisecs\n' % DirtyExpireCentisecs) 
         if self.ui.radioTCPTimestamps.isChecked() == True:
             destination.write('       echo "%s" > /proc/sys/net/ipv4/tcp_timestamps\n' % TCPTimestamps) 
         if self.ui.radioDirtyWritebackCentisecs.isChecked() == True:
             destination.write('       echo "%s" > /proc/sys/vm/dirty_writeback_centisecs\n' % DirtyWritebackCentisecs) 
         if self.ui.radioTCPNoMetricsSave.isChecked() == True:
             destination.write('       echo "%s" > /proc/sys/net/ipv4/tcp_no_metrics_save\n' % TCPNoMetricsSave) 
         if self.ui.radioDirtyRatio.isChecked() == True:
             destination.write('       echo "%s" > /proc/sys/vm/dirty_ratio\n' % DirtyRatio) 
         if self.ui.radioSwappiness.isChecked() == True:
             destination.write('       echo "%s" > /proc/sys/vm/swappiness\n' % Swappiness) 
         if self.ui.radioDirtyBGDRatio.isChecked() == True:
             destination.write('       echo "%s" > /proc/sys/vm/dirty_background_ratio\n' % DirtyBGDRatio) 
         if self.ui.radioVFSCachePressure.isChecked() == True:
             destination.write('       echo "%s" > /proc/sys/vm/vfs_cache_pressure\n' % VFSCachePressure) 
         if self.ui.radiommc0requests.isChecked() == True:
             destination.write('       echo "%s" > /sys/block/mmcblk0/queue/nr_requests\n' % mmc0requests)
         if self.ui.radiommc1requests.isChecked() == True:
             destination.write('       echo "%s" > /sys/block/mmcblk1/queue/nr_requests\n' % mmc1requests)
         if self.ui.radioMinFreekbytes.isChecked() == True:
             destination.write('       echo "%s" > /proc/sys/vm/min_free_kbytes\n' % minFreekbytes)

         destination.write('end script\n')
         destination.close()
         
         ##Update destination file
         if doUpdateConfig() == True:
             message = 'The new configuration has been created and copied to event.d folder.'
             showMessage(message)
             self.ui.actionDeleteTuningFile.setEnabled(True)

         else:
             message = 'FATAL ERROR: The new configuration could not be created.'
             showMessage(message)
 
class SwappolubeMain():
    
     ##Check with what priviledges the GUI is being executed
     if os.geteuid() == 0:
         message ='ERROR: The swappolube editor cannot be executed as root. Exiting..'
         showMessage(message)
         sys.exit(1)
      
     ##Check if temp folder is available
     if os.path.exists(PathTemp) == False:
         os.system('mkdir %s' % PathTemp)
     else:
         pass
   
     ##Open Dialog Window
     app = QtGui.QApplication(sys.argv)
     myapp = swappolubeMainWindow()
     myapp.show()
     sys.exit(app.exec_())