#ifndef MAPTREEITEM_H
#define MAPTREEITEM_H

#include <QTreeWidgetItem>
#include <QMap>
#include <QVariant>
#include <QDebug>
#include "squeezster_icons.h"
#include "metatypes.h"

//#include "squeezster.h"


typedef QVariantMap* variantMap_ptr;

class MapTreeItem : public QTreeWidgetItem

{
    //Q_OBJECT
public:
    //enum {Type = QTreeWidgetItem::UserType+1 };
    enum {Type = 1000 };
    explicit MapTreeItem();
    ~MapTreeItem() {delete map_i;}

    static const int MapItemCol = 0;
    static const int MapItem = 128;
    void setMap(QVariantMap map);
    void setTitle(QString title="");
    void addProperty(QString key, QString val);
    void setIcon();
    void setIcon(QIcon icon) {QTreeWidgetItem::setIcon(0,icon);}
    QString command() {return(property("cmd"));}
    QString id() {return(property("id"));}
    QString type() {return(property("type"));}
    QString search() {return(property("search"));}
    QString property(QString key);
    QString text() {return(QTreeWidgetItem::text(0));}
    QString item_id() {return(QString("item_id:"+property("id")));
    }
    QString album_id() {
        if(!property("album").isEmpty())
            return(QString("album_id:"+property("id")));
        else return(QString());}

    QString folder_id() {
        if(property("type")==QString("folder"))
            return(QString("folder_id:"+property("id")));
        else return(QString());}

    QString track_id() {
        if(property("type")==QString("track"))
            return(QString("track_id:"+property("id")));
        else return(QString());}
    QString title_id() {
        if(!property("title").isEmpty())
            return(QString("track_id:"+property("id")));
        else return(QString());}

    QString artist_id() {
        if(!property("artist").isEmpty())
            return(QString("artist_id:"+property("id")));
        else return(QString());}

    QString playlist_id() {
        if(!property("playlist").isEmpty())
            return(QString("playlist_id:"+property("id")));
        else return(QString());
    }
    QString genre_id() {return(QString("genre_id:"+property("id")));}

    //int id() {return(property("id").toInt());}
    int hasItems() {return(property("hasitems").toInt());}
    int isAudio() {return(property("isaudio").toInt());}
    bool isXmlBrowser() {return(property("type")==QString("xmlbrowser")?true:false);}
    bool typeFolder() {return(property("type")==QString("folder")?true:false);}
    bool typeTrack() {return(property("type")==QString("track")?true:false);}
    bool typeAudio() {return(property("type")==QString("audio")?true:false);}
    QIcon icon() {return(QTreeWidgetItem::icon(MapItemCol));}
    QString name() {return(property("name"));}
    QString title() {return(property("title"));}

signals:

public slots:


private:
    //QVariant variant;
    QVariantMap* map_i;
};

Q_DECLARE_METATYPE(MapTreeItem)
Q_DECLARE_METATYPE(MapTreeItem*)
#endif // MAPTREEITEM_H
