#ifndef USERSETTINGS_H
#define USERSETTINGS_H

#include <QObject>
#include <QFile>
#include <QDebug>

//#define IPADDRESS "patrikkarlsson.mine.nu"
#define IPADDRESS "127.0.0.1"
#define HTTPPORT 9000
#define CLIPORT 9090
#define CONFIGFILE ".squeezster.config"

class UserSettings
{
    //Q_OBJECT

public:
    explicit UserSettings();


//    UserSettings(const UserSettings &other);

    QString setIpAddress(QString newIpAddress);
    quint16 setHttpPort(quint16 newHttpPort);
    quint16 setCliPort(quint16 newCliPort);
    QString setUsername(QString newUsername);
    QString setPassword(QString newPassword);
    //quint16 setScreensaverIsInhibited(quint16 newScreensaverIsInhibited);
    bool    setScreensaverIsInhibited(bool newScreensaverIsInhibited);
    bool    setLargeAlbumIcons(bool newLargeAlbumIcons);
    bool    setAlbumIcons(bool newAlbumIcons);

    QString username() const {return(username_i);}
    QString password() const {return(password_i);}
    const QString ipAddress() const {return(ipAddress_i);}
    quint16 httpPort() const {return(httpPort_i);}
    quint16 cliPort() const {return(cliPort_i);}
    bool    screensaverIsInhibited() const {return(screensaverIsInhibited_i);}
    bool    largeAlbumIcons() const {return(largeAlbumIcons_i);}
    bool    albumIcons() const {return(albumIcons_i);}

    //bool load();
    //bool save();
    bool clone(const UserSettings &other);
    const bool operator==(const UserSettings &rhs) const;
    const bool operator!=(const UserSettings &rhs) const;

signals:

public slots:

private:

    QString username_i;
    QString password_i;
    QString ipAddress_i;
    quint16 httpPort_i;
    quint16 cliPort_i;
    bool    screensaverIsInhibited_i;
    bool    largeAlbumIcons_i;
    bool    albumIcons_i;
};

#endif // USERSETTINGS_H
