#include "squeezeresponse.h"


squeezeResponse::squeezeResponse() {
    responseByteArray = "";
    filterList << "audioscrobbler" << "trackstat" ;
}

squeezeResponse::squeezeResponse(QTextStream *newStream) {
    in = newStream;
    responseByteArray = "";
    filterList << "audioscrobbler" << "trackstat" ;

}

squeezeResponse::squeezeResponse(QTcpSocket* newTcpSocket, QTextStream *newStream) {
    tcpSocket = newTcpSocket;
    in = newStream;
    responseByteArray = "";
    filterList << "audioscrobbler" << "trackstat" ;

}

squeezeResponse::squeezeResponse(QTcpSocket* newTcpSocket) {
    tcpSocket = newTcpSocket;
    responseByteArray = "";
    filterList << "audioscrobbler" << "trackstat" ;

}

void  squeezeResponse::setTcpSocket(QTcpSocket* newTcpSocket)
{
    tcpSocket = newTcpSocket;
}
void squeezeResponse::setTextStream(QTextStream *newStream)
{
    in = newStream;
}


QList<QByteArray> squeezeResponse::readResponseWait()
{
    if (tcpSocket->waitForReadyRead(5000))
    {
        readResponse();}
    else {
        qDebug() << "readResponseWait() TIME OUT";
    }
    return(responseByteArrayList);
}



void squeezeResponse::readResponse()
{
    qDebug() << "squeezeResponse(): Entering readResponse()";
        if(!in->atEnd())
            responseByteArray+=in->readAll();
        responseByteArrayList = responseByteArray.split('\n');
        if(!responseByteArrayList.isEmpty()) {
            if(responseByteArrayList.last().endsWith('\n')) {
                qDebug() << "readResponse() " << responseByteArrayList;
                emit responseReceived(responseByteArrayList);
                responseByteArray.clear();
            } else
            {
                responseByteArray = responseByteArrayList.takeLast();
                qDebug() << "readResponse() " << responseByteArrayList;
                emit responseReceived(responseByteArrayList);
            }
        }
    }

QByteArray  squeezeResponse::responseFilter(QByteArray myRawResponse)
{
    bool ok = true;
    qDebug() << "responseFilter(). String:" << myRawResponse;
    QListIterator<QByteArray> strItr(filterList);
    while (strItr.hasNext()) {
        qDebug() << "Filter;" << strItr.peekNext();
        if (myRawResponse.contains(strItr.next()))
            ok = false;
    }
    qDebug() << "responseFilter()" << ok;
    if (ok) return(myRawResponse); else return (0);
}


QList<QByteArray> squeezeResponse::splitResponse(QByteArray concByteArray)
{

    return(concByteArray.split(' '));
}

