#include "optionsdialog.h"
#include "ui_optionsdialog.h"

OptionsDialog::OptionsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::OptionsDialog)
{
    ui->setupUi(this);
}

OptionsDialog::~OptionsDialog()
{
    delete ui;
}

void OptionsDialog::on_clearCachePushButton_clicked()
{
    emit clearCache();
}

void OptionsDialog::on_ssaverCheckBox_toggled(bool checked)
{
        emit ssaverInhibit(checked);
}

void OptionsDialog::on_albumIconsCheckBox_toggled(bool checked)
{
        emit albumIcons(checked);
}
void OptionsDialog::on_buttonBox_accepted()
{
    bool checked = false;
    if (ui->largeAlbumIconsCheckBox->checkState() == Qt::Checked)
    {
        checked = true;
    }
    emit largeAlbumIcons(checked);
}

void OptionsDialog::setScreensaverInhibitedState(bool ssInhibited)
{
    ui->ssaverCheckBox->setChecked(ssInhibited);
}

void OptionsDialog::setAlbumIconsState(bool albumIcons)
{
    ui->albumIconsCheckBox->setChecked(albumIcons);
}

void OptionsDialog::setLargeAlbumIconsState(bool largeAlbumIcons)
{
    ui->largeAlbumIconsCheckBox->setChecked(largeAlbumIcons);
}

void OptionsDialog::on_aboutPushButton_clicked()
{
    //----------------------------------------------
    // OptionsDialog::showAbout()
    // Opens a message display with the "About"
    // information.
    //----------------------------------------------
//    void squeezster::showAbout() {
        QString aboutString = "Squeezster v.";
        aboutString+=VERSION;
        aboutString+="\n";
        aboutString+="By Patrik Karlsson 2011";
    #if defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
        QMessageBox::information(this, tr("About Squeezster"),
                                 tr(aboutString.toLatin1()));
    #else
        //QMessageBox::information(this, tr("About Squeezster"),
        //                         tr(aboutString.toLatin1()));
    #endif
  //  }
  //  emit showAbout();
}
