#include "connectiondialog.h"

connectionDialog::connectionDialog(QWidget *parent,UserSettings oldSettings) :
        QDialog(parent),
        ui(new Ui::connectionDialog)
{
    settings.clone(oldSettings);
    ui->setupUi(this);
    ui->cliPortLineEdit->setText(QString::number(oldSettings.cliPort()));
    ui->httpPortLineEdit->setText(QString::number(oldSettings.httpPort()));
    ui->ipAddressLineEdit->setText(QString(oldSettings.ipAddress()));
    ui->usernameLineEdit->setText(QString(oldSettings.username()));
    ui->passwordLineEdit->setText(QString(oldSettings.password()));
}

connectionDialog::~connectionDialog()
{
    delete ui;
}

void connectionDialog::on_buttonBox_accepted()
{
    bool ok;
    if (!(settings.setCliPort(ui->cliPortLineEdit->text().toInt(&ok))) || !ok)
        settings.setCliPort(9090);
    if (!(settings.setHttpPort(ui->httpPortLineEdit->text().toInt(&ok))) || !ok)
        settings.setHttpPort(9000);
    settings.setIpAddress(ui->ipAddressLineEdit->text());
    settings.setUsername(ui->usernameLineEdit->text());
    settings.setPassword(ui->passwordLineEdit->text());

    emit(connectionSettingsUpdated(settings));

}

void connectionDialog::on_buttonBox_rejected()
{
    qDebug() << "Connection settings rejected";
    exit(1);
}
