#include "xmllistitem.h"

xmlListItem::xmlListItem(QListWidget* parent) : //,QString listType) :
        QListWidgetItem(parent,Type)
{
    hash=new QVariantHash();
    qVariantSetValue(variant,hash);
    setData(xmlItem,variant);

 setData(xmlItemCol,variant);

}


void xmlListItem::addProperty(QString key, QString val)
{
    QVariant propVariant;
    qVariantSetValue(propVariant,val);
    QVariantHash* hash=QVariant(data(xmlItem)).value<QVariantHash*>();
    hash->insert(key.toLower(),propVariant);
    if(property("type")==QString("status")) {
        if((key==QString("artist")) || (key==QString("title"))) {
            setText(QString(title()+" - "+artist()));
        }
    }

    if(property("type")==QString("albums")) {
        if(key==QString("album")) {
            setText(QString(val));
        }
    }

    if(property("type")==QString("titles")) {
        if(key==QString("title")) {
            setText(QString(val));
        }
    }

    if(property("type")==QString("artists")) {
        if(key==QString("artist")) {
            setText(QString(val));
        }
    }

    if(property("type")==QString("playlists")) {
        if(key==QString("playlist")) {
            setText(QString(val));
        }
    }
}

QString xmlListItem::property(QString key)
{
    QVariantHash* hash;
    QVariant variant = data(xmlItem);
    //hash = qVariantValue(variant);
    //QVariantHash* hash=QVariant(data(xmlItem)).value<QVariantHash*>();
    hash = qvariant_cast<QVariantHash*>(variant);
    QVariant propVariant;
    propVariant = hash->value(key.toLower());
    return(propVariant.toString());
}

void xmlListItem::setIcon()
{
    //QListWidgetItem::setIcon(QIcon(MUSICNOTESPIXMAPFILE));
    setIcon(QIcon(SMALLBULLETPIXMAPFILE));
}

QString xmlListItem::albumArtUrl(QString ipAddress, quint16 httpPort) {
    QString temp="";
    bool ok=false;
    quint16 id;
    if (isRemote() && !property("artwork_id").isEmpty())
    {
        temp = property("artwork_id");
        if (!temp.startsWith("http",Qt::CaseInsensitive)) {
            temp= QString("http://"+ipAddress+':'+QString::number(httpPort)+"/" +temp);
        }
    } else {
        if (((id=property("id").toInt(&ok))>0) && ok) {
            temp = QString("http://"+ipAddress+':'+QString::number(httpPort)+"/music/" + QString::number(id) + LOCALALBUMARTSUFFIX);
        }
    }
    return(temp);
}
