#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "LocationModule.h"
#include <QTimer>
float speed=0;
extern Speedo *pW;
float trip=0;
float total=0;
int appClose=0;
float average_speed=0;
float seconds=0;
//LocationThread l;
int d_speed=0;
float d_trip=0;
float d_total=0;
float d_average=0;


Speedo::Speedo(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::Speedo)
{
    ui->setupUi(this);
    unit = 0;
    //ui->lcdNumber->display(speed);
    //ui->lcdNumber->setBaseSize(32,32);

    //ui->lcdNumber_3->setDigitCount(7);
    //ui->lcdNumber_2->setDigitCount(7);
    ui->lcdNumber->setDigitCount(10);
    //ui->lcdNumber_4->setDigitCount(10);

    // load total distance and unit setting from a file
    FILE *fp=fopen("/home/user/.speedrec","r");
    int fileSize;
    if(0!=fp)
    {
        fseek(fp,0,SEEK_END);
        fileSize = ftell(fp);
        rewind(fp);

        fscanf(fp,"%f",&total);
        if(fileSize>=10) // if new .speedrec file
        fscanf(fp,"%d",&unit);
        fclose(fp);
    }
    hour=min=sec=tensofsec=0;
    started=0;paused=0;
    display=0; // set default to speed display
    QTimer *t=new QTimer(this);
    connect(t,SIGNAL(timeout()),this,SLOT(updateLocation()) );
    t->start(1000);
    QTimer *t2=new QTimer(this);
    connect(t2,SIGNAL(timeout()),this,SLOT(updateTime()) );
    t2->start(100);

}

Speedo::~Speedo()
{
    delete ui;
    FILE *fp=fopen("/home/user/.speedrec","w");
    if(0!=fp)
    {
        fprintf(fp,"%f %d",total,unit);
        fclose(fp);
    }
    stopLocation();
}

void Speedo::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Speedo::on_pushButton_clicked()
{
    trip=0;seconds=0;
}
void Speedo::start_gps()
{
   initLocation();
}
void Speedo::updateLocation()
{
    speed = locationModuleVar_Speed;
    //speed++;
    float mpersec = (float)(speed)/3600*1000;
    //float delta_dist = mpersec;
    trip += mpersec/1000;
    total+=mpersec/1000;

    if(seconds>5.0f)
        average_speed = (trip*1000)/seconds;
    else
        average_speed=0;
    average_speed*=3.6f; // km / h
    if(unit==0)
    {
        //ui->label->setText("km/h");
        //ui->label_2->setText("km (trip)");
        //ui->label_3->setText("km");
        //ui->label_5->setText("km/h");
        d_speed=(int)speed;
        d_trip = trip;
        d_total=total;
        d_average = average_speed;

    }
    else
    {
        d_speed =(int)(speed/1.609);
        d_trip = trip/1.609;
        d_total=total/1.609;
        d_average=average_speed/1.609;
        //ui->label->setText("mph");
        //ui->label_2->setText("mi (trip)");
        //ui->label_3->setText("mi");
        //ui->label_5->setText("mph");

    }


}

void Speedo::updateTime()
{

    QString sUnit;
    if(unit==0)sUnit="km";else sUnit="mi";

    char buf[20];
    if(display==0)
    {
        ui->lcdNumber->setDigitCount(3);
        ui->lcdNumber->display(d_speed);
        QString text;
        text=sUnit+"/h";
        ui->label->setText(text);
    }
    else if(display==1)
    {
        ui->lcdNumber->setDigitCount(7);
        sprintf(buf,"%.2f",d_trip);
        // replace , with . for QLcdNumber
    for(unsigned int i=0;i<strlen(buf);i++){
        if(buf[i]==',')buf[i]='.';}
    QString text=sUnit+" (trip)";
    ui->lcdNumber->display(QString(buf));
    ui->label->setText(text);
    }
    else if(display==2)
    {
        ui->lcdNumber->setDigitCount(7);
    sprintf(buf,"%.2f",d_total);
    // replace , with . for QLcdNumber
    for(unsigned int i=0;i<strlen(buf);i++){
        if(buf[i]==',')buf[i]='.';}
    ui->lcdNumber->display(QString(buf));
    ui->label->setText(sUnit);
    }
    else if(display==3)
    {
        ui->lcdNumber->setDigitCount(7);
    sprintf(buf,"%.2f",d_average);
    // replace , with . for QLcdNumber
    for(unsigned int i=0;i<strlen(buf);i++){
        if(buf[i]==',')buf[i]='.';}
    ui->lcdNumber->display(QString(buf));
    QString text=sUnit+"/h (avg.speed)";
    ui->label->setText(text);
    }
    else if(display==4)
    {
        ui->lcdNumber->setDigitCount(10);
        char buf[80];char h[3],m[3],s[3];
        if(hour<10)sprintf(h,"0%d",hour);else sprintf(h,"%d",hour);
        if(min<10)sprintf(m,"0%d",min);else sprintf(m,"%d",min);
        if(sec<10)sprintf(s,"0%d",sec);else sprintf(s,"%d",sec);

        sprintf(buf,"%s.%s.%s.%d",h,m,s,tensofsec);
        ui->lcdNumber->display(QString(buf));
        ui->label->setText("");

    }
    if(!started)return;
    if(paused)return;
    tensofsec++;
    if(tensofsec==10)
    {
       tensofsec=0;sec++;seconds++;
       if(sec==60)
       {
           sec=0;min++;
           if(min==60)
           {
               min=0;hour++;
           }
       }
    }

}

void Speedo::on_pushButton_2_clicked()
{
    unit = 1-unit; // 0 km, 1-miles
}

void Speedo::on_startTimeButton_clicked()
{
    started=1;paused=0;display=4;

}

void Speedo::on_pauseTimeButton_clicked()
{
    if(paused){
        hour=min=sec=tensofsec=seconds=0;started=0;average_speed=0;
    }
    paused=1-paused;display=4;

}

void Speedo::on_pushButton_3_clicked()
{
    display++;
    if(display>4)
        display=0;
}
