//    smssend
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef SMSSENDER_H
#define SMSSENDER_H

#include <QCoreApplication>
#include <QStringList>
#include <QFile>
#include <glib-2.0/glib.h>
#include <rtcom-eventlogger/eventlogger.h>
#include <rtcom-eventlogger/event.h>
#include "ptyi.h"

#define COMMAND_TIMEOUT 500

class SmsSender : public QCoreApplication
{
public:
    explicit SmsSender(int argc, char *argv[]);
    ~SmsSender();
    int exec();

private:
    enum args{
        argNone,
        argNumber,
        argText,
        argCompose,
        argSend,
        argLog,
        argDontSave,
        argFlash,
        argDeliveryReport,
        argValidity,
    };

    enum errors{
        errNoError = 0,
        errArguments = -1,
        errSmsFailed = -2,
        errLogfileOpenFailed = -3,
    };

    RTComEl* m_El;
    int m_Argc;
    QStringList m_Argv;
    bool m_Compose;
    bool m_Send;
    bool m_Save;
    bool m_Flash;
    //bool m_DeliveryReport;
    int m_Validity;
    QFile* m_LogFile;

    void consoleOutput(QString output, bool newline=true);
    void printInfo();
    void printUsage();

    bool compose(QString number, QString messageText);
    bool send(QString number, QString message);
    bool writeCmd(Pty* p, QString cmd, QString okReply, int msectimeout=COMMAND_TIMEOUT);

    bool saveMsgToSentFolder(QString number, QString message);
};

#endif // SMSSENDER_H
