/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QtTest>
#include <QtGui>

#include "../../../src/ui/friendlistitem.h"
#include "../../../src/ui/friendlistview.h"
#include "../../../src/user/user.h"

class TestFriendListView: public QObject
{
    Q_OBJECT

private slots:
    void cleanupTestCase();
    void initTestCase();
    void addListItem();
    void addItemToView();
    void clearUnused();
    void filterListByID();
    void filterListByName();
    void takeListItemFromView();

private:
    int hiddenItemCount();

private:
    FriendListView *friendListView;
    User *user1;
    User *user2;
    User *user3;
    User *user4;
};

void TestFriendListView::cleanupTestCase()
{
    delete friendListView;
    delete user1;
    delete user2;
    delete user3;
    delete user4;
}

void TestFriendListView::initTestCase()
{
    friendListView = new FriendListView();
    QVERIFY(friendListView != 0);

    user1 = new User(QString("Address address address address address"),
                           GeoCoordinate(12.22, 23.33), QString("John Doe"),
                           QString("Note note note note note note note note"),
                           QUrl("http://image.url"), QString("Timestamp timestamp timestamp tim"),
                           true, QString("key1"), QString("km"), 44.12);
    user1->setProfileImage(QPixmap(":/res/images/profile_pic_border.png"));

    user2 = new User(QString("Address address"),
                           GeoCoordinate(12.1, 44.33), QString("Jane Doe"),
                           QString("Note note note note note note note note"),
                           QUrl("http://image.url"), QString("Timestamp timestamp timestamp tim"),
                           true, QString("key2"), QString("km"), 144.12);
    user2->setProfileImage(QPixmap(":/res/images/profile_pic_border.png"));

    user3 = new User(QString("Address address address address address"),
                           GeoCoordinate(12.22, 23.33), QString("Kate Nameless"),
                           QString("Note note note note note note note note"),
                           QUrl("http://image.url"), QString("Timestamp timestamp timestamp tim"),
                           true, QString("key3"), QString("km"), 44.12);
    user3->setProfileImage(QPixmap(":/res/images/profile_pic_border.png"));

    user4 = new User(QString("Address address"),
                           GeoCoordinate(12.1, 44.33), QString("Jay Nameless"),
                           QString("Note note note note note note note note"),
                           QUrl("http://image.url"), QString("Timestamp timestamp timestamp tim"),
                           true, QString("key4"), QString("km"), 144.12);
    user4->setProfileImage(QPixmap(":/res/images/profile_pic_border.png"));

    QVERIFY(user1 != 0);
    QVERIFY(user2 != 0);
    QVERIFY(user3 != 0);
    QVERIFY(user4 != 0);
}

void TestFriendListView::addListItem()
{
    friendListView->addListItem("key1", new FriendListItem());
    QCOMPARE(friendListView->count(), 1);

    friendListView->addListItem("key1", new FriendListItem());
    QCOMPARE(friendListView->count(), 1);

    friendListView->addListItem("key2", new FriendListItem());
    QCOMPARE(friendListView->count(), 2);
}

void TestFriendListView::addItemToView()
{
    friendListView->addListItemToView(new FriendListItem());
    QCOMPARE(friendListView->count(), 3);

    friendListView->addListItemToView(new FriendListItem());
    QCOMPARE(friendListView->count(), 4);

    friendListView->clearList();
    QCOMPARE(friendListView->count(), 0);
}

void TestFriendListView::clearUnused()
{
    friendListView->addListItem("key1", new FriendListItem());
    friendListView->addListItem("key2", new FriendListItem());
    friendListView->addListItem("key3", new FriendListItem());
    friendListView->addListItem("key4", new FriendListItem());
    QCOMPARE(friendListView->count(), 4);

    QStringList newUserIDs;
    newUserIDs.append("key2");
    newUserIDs.append("key3");
    friendListView->clearUnused(newUserIDs);
    QCOMPARE(friendListView->count(), 2);
    QVERIFY(friendListView->listItem("key1") == 0);
    QVERIFY(friendListView->listItem("key2") != 0);
    QVERIFY(friendListView->listItem("key3") != 0);
    QVERIFY(friendListView->listItem("key4") == 0);
}

void TestFriendListView::filterListByID()
{
    friendListView->clearList();
    QCOMPARE(friendListView->count(), 0);

    FriendListItem *item1 = new FriendListItem();
    FriendListItem *item2 = new FriendListItem();
    FriendListItem *item3 = new FriendListItem();;
    FriendListItem *item4 = new FriendListItem();

    item1->setUserData(user1);
    item2->setUserData(user2);
    item3->setUserData(user3);
    item4->setUserData(user4);

    friendListView->addListItem("key1", item1);
    friendListView->addListItem("key2", item2);
    friendListView->addListItem("key3", item3);
    friendListView->addListItem("key4", item4);
    QCOMPARE(friendListView->count(), 4);

    QList<QString> userIDs;
    userIDs.append("key1");
    friendListView->filter(userIDs);
    QCOMPARE(friendListView->count(), 4);
    QCOMPARE(hiddenItemCount(), 3);

    userIDs.append("key2");
    friendListView->filter(userIDs);
    QCOMPARE(friendListView->count(), 4);
    QCOMPARE(hiddenItemCount(), 2);

    friendListView->clearFilter();
    QCOMPARE(hiddenItemCount(), 0);
}

void TestFriendListView::filterListByName()
{
    friendListView->clearList();
    QCOMPARE(friendListView->count(), 0);

    FriendListItem *item1 = new FriendListItem();
    FriendListItem *item2 = new FriendListItem();
    FriendListItem *item3 = new FriendListItem();;
    FriendListItem *item4 = new FriendListItem();

    item1->setUserData(user1);
    item2->setUserData(user2);
    item3->setUserData(user3);
    item4->setUserData(user4);

    friendListView->addListItem("key1", item1);
    friendListView->addListItem("key2", item2);
    friendListView->addListItem("key3", item3);
    friendListView->addListItem("key4", item4);
    QCOMPARE(friendListView->count(), 4);

    friendListView->filter("doe");
    QCOMPARE(hiddenItemCount(), 2);

    friendListView->filter("j");
    QCOMPARE(hiddenItemCount(), 1);

    friendListView->filter("john");
    QCOMPARE(hiddenItemCount(), 3);

    friendListView->clearFilter();
    QCOMPARE(hiddenItemCount(), 0);
}

void TestFriendListView::takeListItemFromView()
{
    QCOMPARE(friendListView->count(), 4);

    ListItem *item = friendListView->takeListItemFromView("key3");
    QVERIFY(item != 0);
    QCOMPARE(friendListView->count(), 3);

    friendListView->addListItemToView(item);
    QCOMPARE(friendListView->count(), 4);
}

int TestFriendListView::hiddenItemCount()
{
    int hiddenCounter = 0;

    for (int i = 0; i < friendListView->count(); ++i) {
        if (friendListView->item(i)->isHidden())
            hiddenCounter++;
    }

    return hiddenCounter;
}

QTEST_MAIN(TestFriendListView)
#include "testfriendlistview.moc"
