/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/


#include <QtCore/QString>
#include <QtTest/QtTest>

#include "routing/routesegment.h"

class TestRouteSegment : public QObject
{
    Q_OBJECT

private Q_SLOTS:
    void settersAndGetters();
    void streetNameParser();
    void streetNameParser_data();
};

void TestRouteSegment::settersAndGetters()
{
    // test data
    int seconds = 10;
    int positionIndex = 2;
    qreal azimuth = 320;
    qreal length = 123.4;
    qreal angle = -12;
    QString direction = "NW";
    QString instructionText = "Turn left at Oxford Street";
    QString lengthCaption = "123 m";
    QString turnType = "TL";

    RouteSegment segment;

    // set values
    segment.setAzimuth(azimuth);
    segment.setEarthDirection(direction);
    segment.setInstruction(instructionText);
    segment.setLength(length);
    segment.setLengthCaption(lengthCaption);
    segment.setPositionIndex(positionIndex);
    segment.setTime(seconds);
    segment.setTurnAngle(angle);
    segment.setTurnType(turnType);

    // test values
    QCOMPARE(segment.azimuth(), azimuth);
    QCOMPARE(segment.earthDirection(), direction);
    QCOMPARE(segment.instruction(), instructionText);
    QCOMPARE(segment.length(), length);
    QCOMPARE(segment.lengthCaption(), lengthCaption);
    QCOMPARE(segment.positionIndex(), positionIndex);
    QCOMPARE(segment.time(), seconds);
    QCOMPARE(segment.turnAngle(), angle);
    QCOMPARE(segment.turnType(), turnType);
}

void TestRouteSegment::streetNameParser()
{
    QFETCH(QString, turnType);
    QFETCH(QString, instruction);
    QFETCH(QString, result);

    RouteSegment segment;
    segment.setTurnType(turnType);
    segment.setInstruction(instruction);

    QCOMPARE(segment.street(), result);
}

void TestRouteSegment::streetNameParser_data()
{
    QTest::addColumn<QString>("turnType");
    QTest::addColumn<QString>("instruction");
    QTest::addColumn<QString>("result");

    QTest::newRow("first segment")
            << "" << "Head northwest on Kiviharjunlenkki" << "Kiviharjunlenkki";
    QTest::newRow("continue (go straight)")
            << "C" << "Continue on 847/Heikinkatu" << "847/Heikinkatu";
    QTest::newRow("turn left")
            << "TL" << "Turn left at Kajaanintie" << "Kajaanintie";
    QTest::newRow("turn slight left")
            << "TSLL" << "Slight left at 847/Uusikatu" << "847/Uusikatu";
    QTest::newRow("turn sharp left")
            << "TSHL" << "Sharp left at Erottajankatu" << "Erottajankatu";
    QTest::newRow("turn right")
            << "TR" << "Turn right at Linnakatu" << "Linnakatu";
    QTest::newRow("turn slight right")
            << "TSLR" << "Slight right at 847/Lävistäjä" << "847/Lävistäjä";
    QTest::newRow("turn sharp right")
            << "TSHR" << "Sharp right at Arkadiankatu" << "Arkadiankatu";
    QTest::newRow("U-turn")
            << "TU" << "Make a U-turn" << "";

    QTest::newRow("first segment, road name with numbers")
            << "" << "Head west on 4;9;13;23/Vaajakoskentie" << "4;9;13;23/Vaajakoskentie";
    QTest::newRow("first segment, unknown road")
            << "" << "Head northeast" << "";

    QTest::newRow("roundabout, 1st exit")
            << "EXIT1" << "At the roundabout, take the 1st exit onto Kaitoväylä"
            << "Kaitoväylä";
    QTest::newRow("roundabout, 2nd exit")
            << "EXIT2" << "At the roundabout, take the 2nd exit onto 4;9;13;23"
            << "4;9;13;23";
    QTest::newRow("roundabout, 3rd exit")
            << "EXIT3" << "At the roundabout, take the 3rd exit onto 4;9;13;23"
            << "4;9;13;23";
    QTest::newRow("roundabout, 5th exit")
            << "EXIT5" << "At the roundabout, take the 5th exit onto 4;9;13;23"
            << "4;9;13;23";

    QTest::newRow("unknown turn type code, IGNORE THIS MESSAGE WHEN RUNNING THE UNIT TEST")
            << "ABCD123" << "At the roundabout, take the 5th exit onto 4;9;13;23"
            << "At the roundabout, take the 5th exit onto 4;9;13;23";


}

QTEST_APPLESS_MAIN(TestRouteSegment);

#include "testroutesegment.moc"
