/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Katri Kaikkonen - katri.kaikkonen@ixonos.com
      Henri Lampela - henri.lampela@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef UPDATELOCATIONDIALOG_H
#define UPDATELOCATIONDIALOG_H

#include <QDialog>

#ifdef Q_WS_MAEMO_5
#include <QAbstractKineticScroller>
#endif // Q_WS_MAEMO_5

#include "texteditautoresizer.h"

class QCheckBox;
class QDialogButtonBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QScrollArea;
class QTextEdit;

/**
* @brief Update Location UI
*
* UI for update location functionality.
*/
class UpdateLocationDialog : public QDialog
{
    Q_OBJECT

public:
    /**
    * @brief Default constructor
    *
    * @param userMessage update location dialog message
    * @param publishOnFacebook update location dialog Facebook publish policity
    * @param parent
    */
    UpdateLocationDialog(const QString &userMessage = "", bool publishOnFacebook = false,
                         QWidget *parent = 0);

    ~UpdateLocationDialog();

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public slots:
    /**
    * @brief Used to set the street address to location label
    *
    * @param address Street address, result from SituareService's reverseGeo
    */
    void setAddress(const QString &address);

private slots:
    /**
    * @brief Used to connect send button
    *
    */
    void sendUpdate();

    /**
    * @brief Used to get changes in messagetext
    *
    */
    void textChanged();

    /**
    * @brief Used to clear default messagetext
    *
    */
    void textSelectionChanged();

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
    * @brief Routing signal for requestLocationUpdate to SituareEngine via MainWindow class
    *
    * @param status Status message
    * @param publish Publish on Facebook
    */
    void statusUpdate(const QString &status, const bool &publish);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QCheckBox *m_checkBox;          ///< Pointer to CheckBox
    QLabel *m_charCountLabel;       ///< Pointer to character counter label
    QLabel *m_locationLabel;        ///< Pointer to locationLabel
    QTextEdit *m_textEdit;          ///< Pointer to TextEdit
};

#endif // UPDATELOCATIONDIALOG_H
