#include <QDebug>

#include "avatarimage.h"
#include "../common.h"
#include "listcommon.h"

#include "searchhistorylistitem.h"

const int SEARCH_HISTORY_SUBITEM_TEXT_MAX_WIDTH = SUBITEM_TEXT_MAX_WIDTH + MARGIN + IMAGE_WIDTH;

SearchHistoryListItem::SearchHistoryListItem()
{
    qDebug() << __PRETTY_FUNCTION__;

    setSubitemTextWidth(SEARCH_HISTORY_SUBITEM_TEXT_MAX_WIDTH);
}

SearchHistoryListItem::~SearchHistoryListItem()
{
    qDebug() << __PRETTY_FUNCTION__;
}

QDateTime SearchHistoryListItem::dateTime() const
{
    return m_dateTime;
}

void SearchHistoryListItem::setDateTime(const QDateTime &dateTime)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (dateTime.isNull())
        m_dateTime = QDateTime::currentDateTime();
    else
        m_dateTime = dateTime;
}

void SearchHistoryListItem::setSearchHistoryData(const QString &searchString,
                                                 const QDateTime &dateTime)
{
    qDebug() << __PRETTY_FUNCTION__;

    setDateTime(dateTime);
    setTitle(shortenText(searchString, ITEM_WIDTH - 3 * MARGIN, ListItem::TEXT_SIZE_NORMAL));
    setImage(AvatarImage::create(QPixmap(":/res/images/search_history.png"), AvatarImage::Small));

    clearSubItems();
    addSubItem(m_dateTime.toString(), QPixmap(":/res/images/calendar.png"));
}
