#include <QDebug>

#include "routewaypointlistitem.h"

#include "routewaypointlistview.h"

RouteWaypointListView::RouteWaypointListView(QWidget *parent)
    : ListView(parent)
{
    qDebug() << __PRETTY_FUNCTION__;
}

bool RouteWaypointListView::listItemClicked(ListItem *item)
{
    qDebug() << __PRETTY_FUNCTION__;

    bool selected = ListView::listItemClicked(item);

    RouteWaypointListItem *routeWaypointItem = dynamic_cast<RouteWaypointListItem*>(item);

    if (routeWaypointItem && selected)
        emit routeWaypointItemClicked(routeWaypointItem->coordinates());

    return selected;
}
