/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef LOCATIONLISTITEM_H
#define LOCATIONLISTITEM_H

#include "extendedlistitem.h"
#include "../routing/location.h"

/**
* @brief List item stores information about location results.
*
* @author Jussi Laitinen - jussi.laitinen (at) ixonos.com
*/
class LocationListItem : public ExtendedListItem
{
public:
    /**
    * @brief Constructor.
    *
    * Sets sub items' text width.
    */
    LocationListItem();

    /**
    * @brief Destructor.
    */
    ~LocationListItem();

/******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
    * @brief Returns location bounds in parameters.
    *
    * @param swBound south-west bound in GeoCoorinate
    * @param neBound north-east bound in GeoCoordinate
    */
    void bounds(GeoCoordinate &swBound, GeoCoordinate &neBound);

    /**
    * @brief Returns item's coordinates.
    *
    * @return item's coordinates
    */
    GeoCoordinate coordinates() const;

    /**
    * @brief Set location data for this item.
    *
    * @param location Location data
    */
    void setLocationData(const Location &location);

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    Location m_location;    ///< Location data
};

#endif // LOCATIONLISTITEM_H
