/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef LISTITEMCONTEXTBUTTONBAR_H
#define LISTITEMCONTEXTBUTTONBAR_H

#include <QWidget>

class QHBoxLayout;
class QPropertyAnimation;

/**
 * @brief Button bar for list item relatex context buttons
 *
 * @author Sami Rämö - sami.ramo (at) ixonos.com
 */
class ListItemContextButtonBar : public QWidget
{
    Q_OBJECT
public:
    /**
      * @brief Constructor
      *
      * @param parent Parent
      */
    explicit ListItemContextButtonBar(QWidget *parent = 0);

    /**
      * @brief Destructor
      *
      * Deletes images.
      */
    ~ListItemContextButtonBar();

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
private:
    /**
      * @brief Paint the background of the item
      *
      * @param event Paint event
      */
    void paintEvent(QPaintEvent *event);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
      * @brief Start hiding animation
      */
    void hideContextButtonBar();

    /**
     * @brief Set new context buttons
     *
     * If bar is hidden, then changeButtons() is called. Otherwise pointer to new buttons is saved
     * and hideContextButtonBar() is called.
     *
     * @param contextButtons Pointer to new context buttons
     */
    void setContextButtons(QWidget *contextButtons);

    /**
      * @brief Start showing animation
      *
      * Animation is started only if the bar contains buttons.
      */
    void showContextButtonBar();

public slots:
    /**
      * @brief Shows and hides the bar when item selection is changed
      *
      * Calls showContextButtonBar() or hideContextButtonBar() if changing the state of the bar is
      * required. If there is a pointer to new buttons, then request is remembered instead of
      * changing the state immediately.
      *
      * @param itemIsSelected True is any item is selected
      */
    void onListItemSelectionChanged(bool itemIsSelected);

private:
    /**
      * @brief Do the actual changing of the buttons
      *
      * Does also re-sizing and re-positioning of the bar and sets new values for animation.
      */
    void changeButtons();

private slots:
    /**
      * @brief
      *
      * If bar was just hidden, then calls changeButtons() if there is a pointer to new buttons
      * saved. If changing the buttons was done, then also checks if showing the bar was requested
      * and calls showContextButtonBar() if needed.
      */
    void onAnimationFinished();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    /**
      * @brief States for the animation
      *
      * @enum AnimationState
      */
    enum AnimationState {
        StateHidden,
        StateOpening,
        StateClosing,
        StateVisible
    };

    bool m_waitForOpen;                 ///< Is showing requested while chaging buttons is not ready

    QHBoxLayout *m_barLayout;           ///< Main layout of this widget

    QPixmap *m_backgroundLeft;          ///< Background picture, left part
    QPixmap *m_backgroundMiddle;        ///< Background picture, center part
    QPixmap *m_backgroundRight;         ///< Background picture, right part

    QPropertyAnimation *m_animation;    ///< Sliding animation for show/hide

    QWidget *m_contextButtons;          ///< Widget for context buttons
    QWidget *m_newContextButtons;       ///< Temporary pointer for new context buttons

    AnimationState m_state;             ///< Current state of the animation
};

#endif // LISTITEMCONTEXTBUTTONBAR_H
