/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com
        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QPainter>
#include <QTimer>

#include "math.h"

#include "fullscreenbutton.h"

const int ROUNDING_ARC_START_ANGLE = 90;    ///< Start angle of the arc
const int ROUNDING_ARC_LENGTH = 90;         ///< Length of the arc (degree)
const int ROUNDING_ARC_RADIUS = 5;          ///< Roundness of the rounded edge

const qreal OPACITY = 0.13;                 ///< Opacity of the background in percents

FullScreenButton::FullScreenButton(QWidget *parent) :
    QToolButton(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    const int HIDING_DELAY_MS = 5000;

    setIcon(QIcon::fromTheme(QLatin1String("general_fullsize")));
    setFixedSize(sizeHint());

    // Normal background
    m_normalColor = new QColor(Qt::black);
    m_normalColor->setAlpha(floor(OPACITY * 255));

    // Selected bakcground
    m_selectedGradient = new QLinearGradient(0, 0, 0, this->height());
    m_selectedGradient->setColorAt(0.02, QColor(0, 113, 181));
    m_selectedGradient->setColorAt(0.25, QColor(24, 142, 214));
    m_selectedGradient->setColorAt(0.5, QColor(41, 162, 239));
    m_selectedGradient->setColorAt(0.75, QColor(82, 195, 255));
    m_selectedGradient->setColorAt(0.98, QColor(115, 215, 255));

    // Item shape path
    m_backgroundPath.moveTo(this->width(), 0);              // Top right corner
    m_backgroundPath.lineTo(ROUNDING_ARC_RADIUS, 0);
    m_backgroundPath.arcTo(0, 0, ROUNDING_ARC_RADIUS * 2, ROUNDING_ARC_RADIUS * 2,
                           ROUNDING_ARC_START_ANGLE, ROUNDING_ARC_LENGTH);
    m_backgroundPath.lineTo(0, this->height());             // Bottom left corner
    m_backgroundPath.lineTo(this->width(), this->height()); // Bottom right corner
    m_backgroundPath.closeSubpath();                        // Back to the beginning

    // Timer for hiding the button automatically after a delay
    m_hidingTimer = new QTimer(this);
    if (m_hidingTimer) {
        m_hidingTimer->setSingleShot(true);
        m_hidingTimer->setInterval(HIDING_DELAY_MS);

        connect(m_hidingTimer, SIGNAL(timeout()),
                this, SLOT(hide()));
    }
}

FullScreenButton::~FullScreenButton()
{
    qDebug() << __PRETTY_FUNCTION__;

    delete m_normalColor;
    delete m_selectedGradient;
}

void FullScreenButton::invoke()
{
    qDebug() << __PRETTY_FUNCTION__;

    if (isHidden())
        show();

    if (m_hidingTimer)
        m_hidingTimer->start();
}

void FullScreenButton::paintEvent(QPaintEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    Q_UNUSED(event);

    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing);

    if(isDown())
        painter.fillPath(m_backgroundPath, QBrush(*m_selectedGradient));
    else
        painter.fillPath(m_backgroundPath, QBrush(*m_normalColor));

    icon().paint(&painter, this->rect());
}
