/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef EXTENDEDLISTITEMDELEGATE_H
#define EXTENDEDLISTITEMDELEGATE_H

#include "listitemdelegate.h"

/**
* @brief Defines ExtendedListItem style.
*
* @author Jussi Laitinen - jussi.laitinen (at) ixonos.com
*/
class ExtendedListItemDelegate : public ListItemDelegate
{

public:
    /**
    * @brief Constructor.
    *
    * @param parent QWidget
    */
    ExtendedListItemDelegate(QWidget *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
    /**
    * @brief Draws ExtendedListItem content.
    *
    * Draws ExtendedListItem sub items icon and text.
    * @param painter QPainter
    * @param option QStyleOptionViewItem
    * @param index QModelIndex
    */
    void paint(QPainter *painter, const QStyleOptionViewItem &option,
               const QModelIndex &index) const;
};

#endif // EXTENDEDLISTITEMDELEGATE_H
