/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/


#ifndef MAPSCROLLER_H
#define MAPSCROLLER_H

#include <QVariantAnimation>

#include "coordinates/scenecoordinate.h"

/**
* @brief Map scroller
*
* Used for kinetic and smooth scroll effects. Class implementation is following the singleton
* desing pattern.
*
* Use QPointF datatype for startValue and endValue. Emitted datatype is SceneCoordinate.
*
* @author Sami Rämö - sami.ramo@ixonos.com
*/
class MapScroller : public QVariantAnimation
{
    Q_OBJECT

private:
    /**
    * @brief Constructor in not accessible because class is using singleton design pattern.
    */
    MapScroller() {}

    /**
    * @brief Destructor in not accessible because class is using singleton design pattern.
    */
    ~MapScroller() {}

    /**
    * @brief Copy constructor in not accessible because class is using singleton design pattern.
    */
    MapScroller(const MapScroller &);

    /**
    * @brief Assignment operator in not accessible because class is using singleton design pattern.
    */
    MapScroller & operator=(const MapScroller &);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
private:
    /**
    * @brief Reimplemented from QVariantAnimation::updateCurrentValue()
    *
    * Called every time the animation's current value changes. Does emit coordinateUpdated() signal
    * if animation is in the running state.
    *
    * @param value New value
    */
    void updateCurrentValue(const QVariant &value);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
    * @brief Get reference to instance of this class
    *
    * Also registers the custom SceneCoordinate interpolator method.
    *
    * @return reference to instance of this class
    */
    static MapScroller &getInstance();

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
    * @brief Signal if emitted when coordinate value is updated
    *
    * @param coordinate New coordinate value
    */
    void coordinateUpdated(SceneCoordinate coordinate);
};

#endif // MAPSCROLLER_H
