/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com
        Henri Lampela - henri.lampela@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QPen>

#include "coordinates/geocoordinate.h"
#include "coordinates/scenecoordinate.h"
#include "map/mapcommon.h"
#include "routing/route.h"

#include "maprouteitem.h"

MapRouteItem::MapRouteItem(QGraphicsItem *parent)
    : QGraphicsItemGroup(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    setZValue(RouteItemZValue);
}

MapRouteItem::MapRouteItem(Route *route, QGraphicsItem *parent)
    : QGraphicsItemGroup(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    setZValue(RouteItemZValue);
    setRoute(route);
}

void MapRouteItem::clear()
{
    qDebug() << __PRETTY_FUNCTION__;

    foreach(QGraphicsItem *item, childItems()) {
        removeFromGroup(item);
        delete item;
    }
}

void MapRouteItem::setRoute(Route *route)
{
    qDebug() << __PRETTY_FUNCTION__;

    const int LINE_WIDTH = 5;
    const QColor LINE_COLOR = Qt::red;

    clear();

    QPen pen;
    pen.setWidth(LINE_WIDTH);
    pen.setColor(LINE_COLOR);
    pen.setCosmetic(true);

    QList<GeoCoordinate> points = route->geometryPoints();
    for (int i = 1; i < points.count(); i++) {
        SceneCoordinate begin = SceneCoordinate(points.at(i - 1));
        SceneCoordinate end = SceneCoordinate(points.at(i));
        QGraphicsLineItem *line = new QGraphicsLineItem(QLineF(begin.toPointF(),
                                                               end.toPointF()));
        line->setPen(pen);
        addToGroup(line);
    }
}
