/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Ville Tiensuu - ville.tiensuu@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QtGlobal>
#include "facebookcredentials.h"

FacebookCredentials::FacebookCredentials()
{
}

void FacebookCredentials::clearCredentials()
{
    m_expires.clear();
    m_sessionKey.clear();
    m_sessionSecret.clear();
    m_sig.clear();
    m_userID.clear();
}

void FacebookCredentials::setSessionKey(const QString & sessionKeyParameter)
{
    m_sessionKey = sessionKeyParameter;
}

void FacebookCredentials::setSessionSecret(const QString & sessionSecretParameter)
{
    m_sessionSecret = sessionSecretParameter;
}


void FacebookCredentials::setExpires (const QString & expiresParameter)
{
    m_expires = expiresParameter;
}

void FacebookCredentials::setUserID (const QString & userIDParameter)
{
    m_userID = userIDParameter;
}

void FacebookCredentials::setSig(const QString & sigParameter)
{
    m_sig = sigParameter;
}

QString FacebookCredentials::sessionKey() const
{
    return m_sessionKey;
}

QString FacebookCredentials::sessionSecret() const
{
    return m_sessionSecret;
}

QString FacebookCredentials::expires() const
{
    return m_expires;
}

QString FacebookCredentials::userID() const
{
    return m_userID;
}

QString FacebookCredentials::sig() const
{
    return m_sig;
}

bool FacebookCredentials::operator==(const FacebookCredentials &credentials)
{
    bool expireBool = (m_expires == credentials.expires());
    bool sessionKeyBool = (m_sessionKey == credentials.sessionKey());
    bool sessionSecretBool = (m_sessionSecret == credentials.sessionSecret());
    bool sigBool = (m_sig == credentials.sig());
    bool userIdBool = (m_userID == credentials.userID());

    return expireBool && sessionKeyBool && sessionSecretBool && sigBool && userIdBool;
}
