/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef MCEPRIVATESTUB_H
#define MCEPRIVATESTUB_H

#include <QObject>

/**
* @brief MCEPrivate class does nothing.
*
* Class is used when not compiling to Maemo.
*/
class MCEPrivate : public QObject
{
    Q_OBJECT

public:
    /**
    * @brief Constructor.
    *
    * @param parent QObject
    */
    MCEPrivate(QObject *parent);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
    * @brief Is the display on.
    *
    * RETURNS TRUE.
    *
    * @return true if on, false if off.
    */
    bool isDisplayOn();

    /**
    * @brief Vibrates the phone for short time.
    *
    * DOES NOTHING.
    */
    void vibrationFeedback();
};

#endif // MCEPRIVATESTUB_H
