#include <QDebug>

#if defined(Q_WS_MAEMO_5) & defined(ARMEL)
#include "contactmanagerprivate.h"
#else
#include "contactmanagerprivatestub.h"
#endif

#include "contactmanager.h"

ContactManager::ContactManager(QObject *parent)
    : QObject(parent),
      m_contactManagerPrivate(0)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_contactManagerPrivate = new ContactManagerPrivate(this);
}

QString ContactManager::contactGuid(const QString &facebookId) const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_contactManagerPrivate->contactGuid(facebookId);
}

void ContactManager::requestContactGuids()
{
    qDebug() << __PRETTY_FUNCTION__;

    m_contactManagerPrivate->requestContactGuids();
}
