/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Pekka Nissinen - pekka.nissinen@ixonos.com
       Kaj Wallin - kaj.wallin@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef ZOOMBUTTONPANEL_H
#define ZOOMBUTTONPANEL_H

#include <QGraphicsItem>
#include <QGridLayout>
#include <QTimer>
#include <QWidget>

#include "zoombutton.h"

/**
 * @brief Panel for zoom buttons
 *
 * @author Pekka Nissinen - pekka.nissinen (at) ixonos.com
 * @author Kaj Wallin - kaj.wallin (at) ixonos.com
 */
class ZoomButtonPanel : public QWidget
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param parent Parent
     */
    ZoomButtonPanel(QWidget *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
     * @brief Move event for the zoom button panel
     *
     * @param event Event
     */
    void mouseMoveEvent(QMouseEvent *event);

    /**
     * @brief Press event for the zoom button panel
     *
     * @param event Event
     */
    void mousePressEvent(QMouseEvent *event);

    /**
     * @brief Event handler for mouse release events
     *
     * @param event Mouse event
     */
    void mouseReleaseEvent(QMouseEvent *event);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
    * @brief Getter for the zoom in button
    *
    * @return Pointer to the zoomInButton
    */
    const ZoomButton* zoomInButton();

    /**
    * @brief Getter for the zoom out button
    *
    * @return Pointer to the zoomOutButton
    */
    const ZoomButton* zoomOutButton();

public slots:
    /**
     * @brief Disables the zoom in button
     */
    void disableZoomInButton();

    /**
     * @brief Disables the zoom out button
     */
    void disableZoomOutButton();

    /**
     * @brief Reset zoom button states to normal
     */
    void resetButtons();

    /**
     * @brief Toggle zoom panel draggability
     */
    void setDraggable(bool mode, QPoint eventPosition = QPoint(0,0));

    /**
    * @brief Slot to redraw the panel after window resize event
    *
    * @param size Size of the new screen
    */
    void screenResized(const QSize &size);

private slots:
    /**
     * @brief Safeguard slot to release mouse grab if something goes horribly wrong
     */
    void forceMouseRelease();

    /**
     * @brief Slot that handles drag initialization once timer has timed out
     */
    void timerExpired();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    bool m_isDraggable;             ///< Boolean for tracking the draggability state

    QGridLayout m_panelLayout;      ///< Panel layout

    QPoint m_dragPosition;          ///< Location from where the widget is grabbed

    QIcon::Mode m_zoomInMode;       ///< Store for zoom in button mode before dragging
    QIcon::Mode m_zoomOutMode;      ///< Store for zoom out button mode before dragging

    QSize m_screenSize;             ///< Store for the screen size

    QTimer *m_dragStartTimer;       ///< Timer to init draggability of the zoom panel
    QTimer *m_forceReleaseTimer;    ///< Timer to run forceMouseRelease;

    ZoomButton *m_zoomInButton;    ///< Button for zoom in
    ZoomButton *m_zoomOutButton;   ///< Button for zoom out
};

#endif // ZOOMBUTTONPANEL_H
