 /*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
 */

#ifndef PANELCOMMON_H
#define PANELCOMMON_H

#include <QString>
#include "../common.h"

// Dragging settings
const int DRAG_INIT_TIME = 1000;        ///< How long buttons must be pressed to start drag mode
const int FORCE_RELEASE_TIME = 10000;   ///< How long mouse can be grabbed

// Common panel settings
enum Side {LEFT, RIGHT};            ///< Enumerator for panel sideness

const int MAEMO5_SCROLLBAR_WIDTH = 8; ///< Width of the Maemo scrollbar

const int PANEL_PEEK_AMOUNT = 27;   ///< Amount of pixels shown when panel is closed
const int PANEL_TOP_PADDING = 0;    ///< Amount of padding in top of panels
const int PANEL_BOTTOM_PADDING = 0; ///< Amount of padding in bottom of panels

const int SIDEBAR_WIDTH = 23;                       ///< Width of the sidebar
const int SIDEBAR_HEIGHT = DEFAULT_SCREEN_HEIGHT - PANEL_TOP_PADDING
                           - PANEL_BOTTOM_PADDING;  ///< Height of the sidebar

const int SLIDER_BAR_WIDTH = 5;                     ///< Width of the slider bar
const int SLIDER_BUTTON_OFFSET = 19;                ///< Slider bar button extrusion width
const int SLIDER_WIDTH = 43;                        ///< Width of the whole slider
const int SLIDER_HEIGHT = DEFAULT_SCREEN_HEIGHT - PANEL_TOP_PADDING
                          - PANEL_BOTTOM_PADDING;   ///< Height of the slider

// Friend list panel settings
const int FRIENDPANEL_WIDTH  = 426;                     ///< Width of the friends list panel
const int FRIENDPANEL_HEIGHT = DEFAULT_SCREEN_HEIGHT - PANEL_TOP_PADDING
                               - PANEL_BOTTOM_PADDING;  ///< Height of the friends list panel

const int FRIENDPANEL_MARGIN_LEFT = SLIDER_BUTTON_OFFSET
                                    + MAEMO5_SCROLLBAR_WIDTH; ///< Friend list panel inner margin (left)
const int FRIENDPANEL_MARGIN_RIGHT = SIDEBAR_WIDTH;         ///< Friend list panel inner margin (right)
const int FRIENDPANEL_MARGIN_TOP = 0;                       ///< Friend list panel inner margin (top)
const int FRIENDPANEL_MARGIN_BOTTOM = 0;                    ///< Friend list panel inner margin (bottom)

const int FRIENDPANEL_FILTER_MARGIN_LEFT = FRIENDPANEL_MARGIN_LEFT + 4; ///< Friend list filter bar margin (left)
const int FRIENDPANEL_FILTER_MARGIN_RIGHT = FRIENDPANEL_MARGIN_RIGHT
                                            + MAEMO5_SCROLLBAR_WIDTH + 4; ///< Friend list filter bar margin (right)

const int SHOW_ALL_BUTTON_RIGHT_MARGIN = SIDEBAR_WIDTH * 2 - 7; ///< Show all button right margin

const int FRIENDPANEL_CLOSED_X = DEFAULT_SCREEN_WIDTH - SLIDER_BUTTON_OFFSET
                                 - PANEL_PEEK_AMOUNT; ///< Horizontal position of a closed friend list panel
const int FRIENDPANEL_OPENED_X = DEFAULT_SCREEN_WIDTH - SLIDER_BUTTON_OFFSET - SLIDER_BAR_WIDTH
                                 - FRIENDPANEL_WIDTH; ///< Horizontal position of a open friend list panel

// User info panel settings
const int USERPANEL_WIDTH  = 298;                       ///< Width of the user panel
const int USERPANEL_HEIGHT = DEFAULT_SCREEN_HEIGHT - PANEL_TOP_PADDING
                             - PANEL_BOTTOM_PADDING;    ///< Height of the user panel

const int USERPANEL_MARGIN_LEFT = SIDEBAR_WIDTH
                                  + MAEMO5_SCROLLBAR_WIDTH; ///< User info panel inner margin (left)
const int USERPANEL_MARGIN_RIGHT = SLIDER_BUTTON_OFFSET;    ///< User info panel inner margin (right)
const int USERPANEL_MARGIN_TOP = 0;                         ///< User info panel inner margin (top)
const int USERPANEL_MARGIN_BOTTOM = 0;                      ///< User info panel inner margin (bottom)

const int USERPANEL_CLOSED_X = - USERPANEL_WIDTH + PANEL_PEEK_AMOUNT
                               - SLIDER_BAR_WIDTH;  ///< Horizontal position of a closed user info panel
const int USERPANEL_OPENED_X = 0;                   ///< Horizontal position of a open user info panel

// Zoom button panel settings
const int ZOOM_BUTTON_PANEL_POSITION_X = 10 + PANEL_PEEK_AMOUNT; ///< Horizontal position of zoom panel
const int ZOOM_BUTTON_PANEL_POSITION_Y = 10; ///< Vertical position of zoom panel
const int ZOOM_BUTTON_PANEL_BUTTON_SPACING = 4; ///< Size of a zoom button spacing

const QString ZOOMPANEL_POSITION = "Zoom_Panel_Position";

#endif // PANELCOMMON_H
