# -------------------------------------------------
# Project created by QtCreator 2010-03-26T07:57:35
# -------------------------------------------------
TARGET = ../situare
TEMPLATE = app
INCLUDEPATH += /usr/include/qjson
LIBS += -lqjson
RESOURCES += ../images.qrc \
    ../languages.qrc
TRANSLATIONS += ../res/languages/situare_fi.ts
SOURCES += main.cpp \
    engine/engine.cpp \
    facebookservice/facebookauthentication.cpp \
    facebookservice/facebookcredentials.cpp \
    gps/gpsposition.cpp \
    map/baselocationitem.cpp \
    map/friendgroupitem.cpp \
    map/frienditemshandler.cpp \
    map/friendlocationitem.cpp \
    map/gpslocationitem.cpp \
    map/mapengine.cpp \
    map/mapfetcher.cpp \
    map/mapscene.cpp \
    map/mapscroller.cpp \
    map/maptile.cpp \
    map/maptilerequest.cpp \
    map/mapview.cpp \
    map/ownlocationitem.cpp \
    network/networkaccessmanager.cpp \
    network/networkcookiejar.cpp \
    network/networkhandler.cpp \
    network/networkreply.cpp \
    situareservice/imagefetcher.cpp \
    situareservice/situareservice.cpp \
    ui/updatelocation/texteditautoresizer.cpp \
    ui/updatelocation/updatelocationdialog.cpp \
    ui/avatarimage.cpp \
    ui/friendlistitem.cpp \
    ui/friendlistpanel.cpp \
    ui/friendlistview.cpp \
    ui/imagebutton.cpp \
    ui/logindialog.cpp \
    ui/mainwindow.cpp \
    ui/mapscale.cpp \
    ui/panelsidebar.cpp \
    ui/panelsliderbar.cpp \
    ui/settingsdialog.cpp \
    ui/sidepanel.cpp \
    ui/sidepanelbase.cpp \
    ui/userinfo.cpp \
    ui/userinfopanel.cpp \
    ui/zoombutton.cpp \
    ui/zoombuttonpanel.cpp \
    user/user.cpp \
    ui/fullscreenbutton.cpp \
    engine/mce.cpp
HEADERS += common.h \
    engine/engine.h \
    facebookservice/facebookauthentication.h \
    facebookservice/facebookcommon.h \
    facebookservice/facebookcredentials.h \
    gps/gpscommon.h \
    gps/gpsposition.h \
    map/baselocationitem.h \
    map/friendgroupitem.h \
    map/frienditemshandler.h \
    map/friendlocationitem.h \
    map/gpslocationitem.h \
    map/mapcommon.h \
    map/mapengine.h \
    map/mapfetcher.h \
    map/mapscene.h \
    map/mapscroller.h \
    map/maptile.h \
    map/maptilerequest.h \
    map/mapview.h \
    map/ownlocationitem.h \
    network/networkaccessmanager.h \
    network/networkcookiejar.h \
    network/networkhandler.h \
    network/networkreply.h \
    situareservice/imagefetcher.h \
    situareservice/situarecommon.h \
    situareservice/situareservice.h \
    ui/updatelocation/texteditautoresizer.h \
    ui/updatelocation/updatelocationdialog.h \
    ui/avatarimage.h \
    ui/friendlistitem.h \
    ui/friendlistpanel.h \
    ui/friendlistview.h \
    ui/imagebutton.h \
    ui/logindialog.h \
    ui/mainwindow.h \
    ui/mapscale.h \
    ui/panelcommon.h \
    ui/panelsidebar.h \
    ui/panelsliderbar.h \
    ui/settingsdialog.h \
    ui/userinfo.h \
    ui/userinfopanel.h \
    ui/sidepanel.h \
    ui/sidepanelbase.h \
    ui/zoombutton.h \
    ui/zoombuttonpanel.h \
    user/user.h \
    ui/fullscreenbutton.h \
    engine/mce.h
QT += network \
    webkit

DEFINES += QT_NO_DEBUG_OUTPUT

simulator {
    SOURCES += network/networkhandlerprivatestub.cpp \
               gps/gpspositionprivate.cpp
    HEADERS += network/networkhandlerprivatestub.h \
               gps/gpspositionprivate.h
    QT += maemo5
    CONFIG += mobility
    MOBILITY += location
} else:maemo5 {
    armel {
        DEFINES += ARMEL
        INCLUDEPATH += /usr/include/glib-2.0 /usr/lib/glib-2.0/include
        SOURCES += network/networkhandlerprivate.cpp \
                   engine/mceprivate.cpp
        HEADERS += network/networkhandlerprivate.h \
                   engine/mceprivate.h
        QT += dbus
        CONFIG += icd2 qdbus
        SOURCES += gps/gpspositionprivateliblocation.cpp \
                   gps/liblocationwrapper.cpp \
                   gps/geopositioninfo.cpp \
                   gps/geocoordinate.cpp
        HEADERS += gps/gpspositionprivateliblocation.h \
                   gps/liblocationwrapper.h \
                   gps/geopositioninfo.h \
                   gps/geocoordinate.h
        CONFIG += link_pkgconfig
        PKGCONFIG += glib-2.0 liblocation mce
        LIBS += -llocation
    } else {
        SOURCES += gps/gpspositionprivatestub.cpp \
                   network/networkhandlerprivatestub.cpp \
                   engine/mceprivatestub.cpp
        HEADERS += gps/gpspositionprivatestub.h \
                   network/networkhandlerprivatestub.h \
                   engine/mceprivatestub.h
    }

    QT += maemo5

    message([QJson])
    message(Make sure you have QJson development headers installed)
    message(add: deb http://repository.maemo.org/extras-devel fremantle free non-free)
    message(to Scratchbox's sources.list in /etc/apt)
    message(run: apt-get update)
    message(install headers with: apt-get install libqjson-dev)
    message([QtMobility])
    message(Make sure you have QtMobility development headers installed)
    message(install headers with: apt-get install libqtm-dev)
} else {
    SOURCES += gps/gpspositionprivatestub.cpp \
               network/networkhandlerprivatestub.cpp \
               engine/mceprivatestub.cpp
    HEADERS += gps/gpspositionprivatestub.h \
               network/networkhandlerprivatestub.h \
               engine/mceprivatestub.h
    message(QJson built in)
    message(Make sure you have QJson development headers installed)
    message(install headers with: sudo apt-get install libqjson-dev)
}

# -----------------------------------------------------------------
# Debian packetizing additions
# -----------------------------------------------------------------
unix {
    # VARIABLES
    isEmpty(PREFIX):PREFIX = /usr
    BINDIR = $$PREFIX/bin
    DATADIR = $$PREFIX/share
    DEFINES += DATADIR=\\\"$$DATADIR\\\" \
        PKGDATADIR=\\\"$$PKGDATADIR\\\"

    # MAKE INSTALL
    desktop.path = $$DATADIR/applications/hildon
    desktop.files += situare.desktop
    INSTALLS += desktop
    icon48.path = $$DATADIR/icons/hicolor/48x48/apps
    icon48.files += ../res/icon/48x48/situare.png
    INSTALLS += icon48
    icon64.path = $$DATADIR/icons/hicolor/64x64/apps
    icon64.files += ../res/icon/64x64/situare.png
    INSTALLS += icon64
    target.path = $$BINDIR
    INSTALLS += target
}
