/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Henri Lampela - henri.lampela@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef SITUARECOMMON_H
#define SITUARECOMMON_H

#include <QString>

// Situare server constants
const QString SITUARE_URL = "http://client.situare.net/";
const QString API_KEY = "4197c64da2fb6b927236feaea32d7d81";

// Test server constants
const QString SITUARE_TEST_URL = "http://emmerichgn.facebook.joyent.us/";
const QString TEST_API_KEY = "cf77865a5070f2c2ba3b52cbf3371579";

// Situare JSON callback data
const QString NORMAL_SIZE_PROFILE_IMAGE = "pic";

// Situare PHP scripts
const QString UPDATE_LOCATION = "updateLocation.php";
const QString REVERSE_GEO = "reversegeo.php";
const QString GET_LOCATIONS =
        QString("getLocations.php?extra_user_data=%1").arg(NORMAL_SIZE_PROFILE_IMAGE);

// Cookies
const QString COOKIE = "Cookie";
const QString USER = "user";
const QString EXPIRES = "expires";
const QString SESSION_KEY = "session_key";
const QString SESSION_SECRET = "ss";

// Locales
const QString LOCALE = "locale";
const QString EN_LOCALE = "en_EN";

// Common marks
const QString QUESTION_MARK = "?";
const QString AMBERSAND_MARK = "&";
const QString EQUAL_MARK = "=";
const QString UNDERLINE_MARK = "_";
const QString BREAK_MARK = ";";
const QString OPENING_BRACE_MARK = "{";

// Coordinates
const QString LATITUDE = "lat";
const QString LONGTITUDE = "lon";

// Url parameters
const QString PUBLISH = "publish";
const QString PUBLISH_TRUE = "true";
const QString PUBLISH_FALSE = "false";
const QString DATA = "data";
const QString JSON_FORMAT = "&format=json";

// Situare server error messages
const QString ERROR_LAT = "Wrong lat value: . Latitude must be between -90 and 90!";
const QString ERROR_LON = "Wrong lon value: . Longitude must be between -180 and 180!";
const QString ERROR_SESSION = "<br />\n<b>Fatal error</b>:"; // starts with

const QString SILHOUETTE_URL = "http://static.ak.fbcdn.net/pics/q_silhouette.gif";

#endif // SITUARECOMMON_H
