/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/


#ifndef MAPTILEREQUEST_H
#define MAPTILEREQUEST_H

#include <QUrl>

/**
* @brief Map tile request
*
* @author Sami Rämö sami.ramo@ixonos.com
*/
class MapTileRequest
{
public:
    /**
    * @brief Constructor
    *
    * Does set cacheChecked to false
    *
    * @param url URL of the requested image
    */
    MapTileRequest(QUrl url);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
public:
    bool cacheChecked; ///< Is this request already checked from the cache
    QUrl url; ///< URL
};

#endif // MAPTILEREQUEST_H
