#include "timedstate.h"

#define INTERNAL_TIMER_TICK 1000 // tick every 1 sec

TimedState::TimedState(const QString& name, int timeout, QState *parent)
    : NamedState(name, parent), m_timeout(timeout)
{
}

void TimedState::onEntry(QEvent *event)
{
    if (!m_timer.isActive())
        m_timer.start(INTERNAL_TIMER_TICK, this);
    m_elapsedTimer.restart();

    NamedState::onEntry(event);
}

void TimedState::onExit(QEvent* /*event*/)
{
    m_timer.stop();
}

void TimedState::timerEvent(QTimerEvent *)
{
    if (m_elapsedTimer.hasExpired(m_timeout))
        emit timeout();
}

void TimedState::setTimeout(int timeout)
{
    if (timeout > 0)
        m_timeout = timeout;
}
