#ifndef SUMMARYDATA_H
#define SUMMARYDATA_H

#include <QObject>
#include <QList>
#include "expensesgraphmodel.h"
#include "concept.h"

class SummaryData : public ExpensesGraphModel
{
        Q_OBJECT
 public:
        SummaryData(int startYear,
                    int startMonth,
                    int endYear,
                    int endMonth,
                    QObject *parent = 0);
        ~SummaryData();

        int startYear();
        int startMonth();
        int endYear();
        int endMonth();

        double totalBudget();
        double totalExpense();
        double totalSaved();
        double maxExpense();
        double minExpense();
        double maxSaved();
        double minSaved();
        double averageExpense();
        double averageSaved();

        void addMonthData(double budget, double expense);
        void addConcept(Concept *c);

        /* form ExpensesGraphModel */
        double budget();
        bool isCurrent();
        int xDivisions();
        double value(int i);
        int label(int i);
        double reference(int i);
        double maxBudget();

        const QList<Concept*>& concepts();

 private:
        int _startYear;
        int _startMonth;
        int _endYear;
        int _endMonth;

        double _totalBudget;
        double _totalExpense;
        double _totalSaved;

        double _maxExpense;
        double _minExpense;
        double _minSaved;
        double _maxSaved;
        double _maxBudget;

        int _monthCount;

        QList<Concept*> _concepts;
        QList<double> _values;
        QList<double> _references;
};

#endif
