#include <QApplication>
#include <QTranslator>
#include <QLibraryInfo>
#include "controller.h"
#include "global.h"


int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    QTranslator qtTranslator;
    qtTranslator.load("qt_" + QLocale::system().name(),
                      QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    app.installTranslator(&qtTranslator);

    QTranslator myappTranslator;
    myappTranslator.load(QString(PROGNAME"_") + QLocale::system().name(),
                         QString(I18N_FILES_PATH));
    app.installTranslator(&myappTranslator);

    Controller controller;

    return app.exec();
}
