#include "scheduledlistmaemo.h"
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QTreeView>
#include <QPushButton>
#include <QLabel>
#include <QIcon>
#include "global.h"

ScheduledListMaemo::ScheduledListMaemo(QStandardItemModel *scheduled,
                                       QWidget *parent)
        : ScheduledList (parent)
{
        setWindowTitle(tr("Scheduled Expenses"));
        setAttribute(Qt::WA_Maemo5StackedWindow);
        setAttribute(Qt::WA_DeleteOnClose);
        setWindowFlags(windowFlags() | Qt::Window);

        QVBoxLayout *layout = new QVBoxLayout (this);

        QPushButton *newButton = new QPushButton(tr("New"));
        newButton->setIcon(QIcon(GENERAL_ADD_ICON));
        layout->addWidget(newButton, 0);
        connect(newButton, SIGNAL(clicked()), this, SIGNAL(newScheduledSelected()));

        QTreeView *tree = new QTreeView();
        tree->setModel(scheduled);
        tree->setProperty("FingerScrollable", true);
        tree->setColumnHidden(SCHEDULED_ID, true);
        tree->setColumnHidden(SCHEDULED_DAY, true);
        tree->setColumnHidden(SCHEDULED_DESCRIPTION, true);
        tree->setColumnHidden(SCHEDULED_MONTH, true);
        tree->setColumnWidth(SCHEDULED_DAY_AS_STRING, 100);
        tree->setColumnWidth(SCHEDULED_AMOUNT, 100);
        tree->setColumnWidth(SCHEDULED_CONCEPT, 200);
        tree->setHeaderHidden(true);
        layout->addWidget(tree, 1);

        connect (tree, SIGNAL(activated(const QModelIndex&)),
                 this, SIGNAL(scheduledDetailsSelected(QModelIndex)));
}

ScheduledListMaemo::~ScheduledListMaemo()
{
}
