#ifndef SCHEDULEDDETAILSDIALOGMAEMO_H
#define SCHEDULEDDETAILSDIALOGMAEMO_H

#include <QLineEdit>
#include <QList>
#include <QDate>
#include "concept.h"
#include <QMaemo5ValueButton>
#include <QStandardItemModel>
#include <QListView>
#include <QDialog>
#include <QItemSelectionModel>
#include <QDialogButtonBox>
#include <QMaemo5ListPickSelector>
#include "scheduleddetailsdialog.h"

class ScheduledDetailsDialogMaemo : public ScheduledDetailsDialog
{
        Q_OBJECT
 public:
        ScheduledDetailsDialogMaemo(QStandardItemModel *concepts,
                                    QWidget *parent = 0,
                                    Qt::WindowFlags f = 0);

        ScheduledDetailsDialogMaemo(QStandardItemModel *concepts,
                                    QStandardItemModel *scheduled,
                                    int row,
                                    QWidget *parent = 0,
                                    Qt::WindowFlags f = 0);

        ~ScheduledDetailsDialogMaemo();

 private slots:
        void conceptSelected(const QString &value);
        void checkValues();
        void deleteClicked();
        void launchMonthDialog();
        void saveMonthSelection();
        void closeMonthDialog();
        void launchDayDialog();
        void saveDaySelection();
        void closeDayDialog();

 private:
        void buildUI (QStandardItemModel *concepts);

        QMaemo5ValueButton *day;
        QMaemo5ValueButton *month;
        QLineEdit *amount;
        QMaemo5ValueButton *concept;
        QMaemo5ListPickSelector *conceptSelector;
        QLineEdit *description;
        int scheduledId;
        int monthSelectionAsInt;
        int daySelectionAsInt;
        int previousFrecuency;

        QDialog *monthDialog;
        QStandardItemModel *monthModel;
        QListView *monthList;
        QItemSelectionModel *monthSelection;

        QDialog *dayDialog;
        QStandardItemModel *dayModel;
        QListView *dayList;
        QItemSelectionModel *daySelection;

        QDialogButtonBox *box;

        bool newScheduled;
};
#endif
