#ifndef MAINWINDOWMAEMO_H
#define MAINWINDOWMAEMO_H

#include <QLineEdit>
#include <QPushButton>
#include <QLabel>
#include <QMouseEvent>
#include <QAction>
#include "monthdata.h"
#include "expensesgraph.h"
#include "mainwindow.h"

class MainWindowMaemo : public MainWindow
{
        Q_OBJECT
 public:
        MainWindowMaemo(QWidget *parent=0);

        QSize minimumSizeHint() const;
        QSize sizeHint() const;

        void setMonthData (MonthData *data);
        void message(const QString& text);

 protected:
        void mousePressEvent(QMouseEvent *event);
        void mouseReleaseEvent(QMouseEvent *event);

 private slots:
        void expensesChanged();
        void budgetChanged();

 private:
        void updateAll();
        void updateDateLabel();
        void updateBudgetLabel();
        void updateTotalLabel();
        void updateSavedLabel();
        void updateGraph();
        void updateAccountLabel();

        MonthData *month;
        ExpensesGraph *graph;
        QLabel *dateLabel;
        QLabel *budgetLabel;
        QLabel *totalLabel;
        QLabel *savedLabel;
        int pressXPosition;
        QAction *budgetAction;
        QAction *expensesAction;
        QAction *scheduledAction;
        QAction *summaryAction;
};
#endif
