#ifndef EXPENSESGRAPH_H
#define EXPENSESGRAPH_H

#include <QWidget>
#include <QList>
#include "expensesgraphmodel.h"

class ExpensesGraph : public QWidget
{
        Q_OBJECT
 public:
        ExpensesGraph(QWidget *parent = 0);

        QSize minimumSizeHint() const;
        QSize sizeHint() const;

        void setPadding(int padding);
        void setModel(ExpensesGraphModel *model);
        void setAccumulated(bool accumulated);
        bool accumulated();

 public slots:
        void changeView();

 protected:
        void paintEvent(QPaintEvent *event);

 private:
        void drawScene(QPainter &painter);
        void drawGrid(QPainter &painter);
        void drawReference(QPainter &painter);
        void drawExpenses(QPainter &painter);

        int _padding;
        bool _accumulated;
        ExpensesGraphModel *_model;
        int xStart, yStart;
        int sceneWidth, sceneHeight;
        int xEnd, yEnd;
        int xStepsPerLabel, yStepsPerLabel;
        int yMaxValue;
        double xStep, yStep;
        double yScale;
        int yLabelWidth;
};


#endif
