#include "expense.h"
#include <QDate>

Expense::Expense(int id,
                 int day,
                 double amount,
                 const QString &concept,
                 const QString &description,
                 int frecuency)
{
        _id = id;
        _day = day;
        _amount = amount;
        _concept.append(concept);
        _description.append(description);
        _frecuency = frecuency;
}

int Expense::id()
{
        return _id;
}

int Expense::day()
{
        return _day;
}

QString Expense::concept()
{
        return _concept;
}

QString Expense::description()
{
        return _description;
}

double Expense::amount ()
{
        return _amount;
}

void Expense::setAmount (double amount)
{
        _amount = amount;
}

void Expense::setId(int id)
{
        _id = id;
}

int Expense::frecuency()
{
        return _frecuency;
}
void Expense::addFrecuency(int frecuency)
{
        _frecuency |= 1 << (frecuency - 1);
}

QString Expense::monthFrecuencyAsString (int frecuency)
{
        QString string;
        int i;
        bool comma = false;

        for (i = 0; i < 12; i++) {
                if (frecuency & (1 << i)) {
                        if (comma) {
                                string.append(", ");
                        } else {
                                comma = true;
                        }
                        string.append(QDate::shortMonthName(i + 1));
                }
        }
        return string;
}

QString Expense::dayFrecuencyAsString (int frecuency)
{
        QString string;
        int i;
        bool comma = false;

        for (i = 0; i < 31; i++) {
                if (frecuency & (1 << i)) {
                        if (comma) {
                                string.append(", ");
                        } else {
                                comma = true;
                        }
                        string += QString("%1").arg(i + 1);
                }
        }
        return string;
}
