#ifndef CONCEPTDETAILSDIALOGDESKTOP_H
#define CONCEPTDETAILSDIALOGDESKTOP_H

#include <QStandardItemModel>
#include <QLabel>
#include <QLineEdit>
#include <QDialogButtonBox>
#include "concept.h"
#include "conceptdetailsdialog.h"

class ConceptDetailsDialogDesktop : public ConceptDetailsDialog
{
        Q_OBJECT
 public:
        ConceptDetailsDialogDesktop(QStandardItemModel *concepts,
                                    int row,
                                    QWidget *parent = 0,
                                    Qt::WindowFlags f = 0);
        ConceptDetailsDialogDesktop(QWidget *parent = 0,
                                    Qt::WindowFlags f = 0);
        QSize minimumSizeHint() const;
        QSize sizeHint() const;

 private slots:
        void saveClicked();
        void deleteClicked();
        void newClicked();

 private:
        QLineEdit *_name;
        QLineEdit *_price;
        QDialogButtonBox *box;
        int _row;
        QString conceptName;
};
#endif
