#include "conceptdetailsdialogdesktop.h"
#include "confirmationdialogdesktop.h"
#include <QVBoxLayout>
#include <QFormLayout>
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QPushButton>
#include <QMessageBox>

ConceptDetailsDialogDesktop::ConceptDetailsDialogDesktop(QStandardItemModel *concepts,
                                                         int row,
                                                         QWidget *parent,
                                                         Qt::WindowFlags f)
        : ConceptDetailsDialog (parent, f)
{
        _row = row;
        setWindowTitle(tr("Item details"));

        QVBoxLayout *layout = new QVBoxLayout (this);

        QVBoxLayout *vBox = new QVBoxLayout();
        layout->addLayout (vBox, 1);
        vBox->addStretch(1);

        QFormLayout *form = new QFormLayout ();
        form->setHorizontalSpacing(50);
        vBox->addLayout (form, 1);

        QLabel *name = new QLabel();
        form->addRow (new QLabel(tr("Name")), name);
        _price = new QLineEdit();
        conceptName = concepts->item(row, 0)->text();
        name->setText(conceptName);
        _price->setText(concepts->item(row, 1)->text());
        form->addRow (new QLabel(tr("Price")), _price);

        box = new QDialogButtonBox (QDialogButtonBox::Cancel, Qt::Horizontal);
        QPushButton *saveButton = new QPushButton(tr("Save"));
        box->addButton(saveButton, QDialogButtonBox::ActionRole);
        QPushButton *deleteButton = new QPushButton(tr("Delete"));
        box->addButton(deleteButton, QDialogButtonBox::ActionRole);

        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
        connect(saveButton, SIGNAL(clicked()), this, SLOT(saveClicked()));
        connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteClicked()));
}

ConceptDetailsDialogDesktop::ConceptDetailsDialogDesktop(QWidget *parent,
                                                         Qt::WindowFlags f)
        : ConceptDetailsDialog (parent, f)
{
        setWindowTitle(tr("Create new item"));

        QVBoxLayout *layout = new QVBoxLayout (this);

        QVBoxLayout *vBox = new QVBoxLayout();
        layout->addLayout (vBox, 1);
        vBox->addStretch(1);

        QFormLayout *form = new QFormLayout ();
        form->setHorizontalSpacing(50);
        vBox->addLayout (form, 1);

        _name = new QLineEdit();
        form->addRow (new QLabel(tr("Name")), _name);
        _price = new QLineEdit();
        form->addRow (new QLabel(tr("Price")), _price);

        box = new QDialogButtonBox (QDialogButtonBox::Cancel, Qt::Horizontal);
        QPushButton *saveButton = new QPushButton(tr("Save"));
        box->addButton(saveButton, QDialogButtonBox::ActionRole);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
        connect(saveButton, SIGNAL(clicked()), this, SLOT(newClicked()));
}

void ConceptDetailsDialogDesktop::saveClicked()
{
        if (_price->text() == "") {
                QMessageBox msgBox(this);
                msgBox.setText(tr("Price field cannot be empty"));
                msgBox.exec();
                return;
        }

        double price = _price->text().toDouble();

        if (price <= 0) {
                QMessageBox msgBox(this);
                msgBox.setText(tr("Invalid price format"));
                msgBox.exec();
                return;
        }

        accept();
        emit updateConceptConfirmed(new Concept(conceptName, price));
}

void ConceptDetailsDialogDesktop::deleteClicked()
{
        QString message(tr("When deleting a concept, all the expenses associated to it "
                           "will be assigned an empty concept instead.\n\n"
                           "Are you sure you want to delete the concept?"));

        if (ConfirmationDialogDesktop::askConfirmation(message, this)) {
                accept();
                emit deleteConceptConfirmed(new Concept(conceptName,0));
        }
}

void ConceptDetailsDialogDesktop::newClicked()
{
        if (_name->text() == "") {
                QMessageBox msgBox(this);
                msgBox.setText(tr("Name field cannot be empty"));
                msgBox.exec();
                return;
        }

        if (_price->text() == "") {
                QMessageBox msgBox(this);
                msgBox.setText(tr("Price field cannot be empty"));
                msgBox.exec();
                return;
        }

        double price = _price->text().toDouble();

        if (price <= 0) {
                QMessageBox msgBox(this);
                msgBox.setText(tr("Invalid price format"));
                msgBox.exec();
                return;
        }

        accept();
        emit newConceptConfirmed(new Concept(_name->text(), price));
}

QSize ConceptDetailsDialogDesktop::minimumSizeHint() const
{
        return QSize(300, 100);
}

QSize ConceptDetailsDialogDesktop::sizeHint() const
{
        return QSize(300, 100);
}
