#ifndef DBMANAGER_H
#define DBMANAGER_H

#include <QObject>
#include <QSqlDatabase>
#include <QSqlError>
#include <QFile>
#include <QDir>
#include <QStandardItemModel>
#include "expense.h"
#include "concept.h"
#include "monthdata.h"
#include "summarydata.h"
#include "account.h"

class DBManager : public QObject
{

 public:
        DBManager();
        ~DBManager();

        bool create(MonthData *month);
        bool load(MonthData *month, bool expensesOnly);
        bool exists(MonthData *month);
        bool updateBudget(int year, int month, int account, double budget);

        bool create(int year, int month, int account, Expense *e);
        bool update(Expense *e);
        bool remove(Expense *e);

        bool create(Concept *c);
        bool loadConcepts(QStandardItemModel *concepts);
        bool update(Concept *c);
        bool remove(Concept *c);
        bool exists(Concept *c);

        bool createScheduled(int account, Expense *e);
        bool removeScheduled(Expense *e);
        bool loadScheduled(int account, QStandardItemModel *scheduled);
        bool updateScheduled(Expense *e);

        bool create(Account *a);
        bool loadAccounts(QStandardItemModel *accounts);
        bool update(Account *a);
        bool remove(Account *a);
        bool exists(Account *a);
        bool load(Account *a);

        bool getDataInterval(int account, int &minYear, int &minMonth, int &maxYear, int &maxMonth);
        bool load(int account, SummaryData *summary);

 private:
        bool existsDB();
        int DBVersion();
        void updateDB();
        bool updateFrom300To400();
        bool updateFrom400To500();
        bool updateFrom500To600();
        void createBackup();
        void restoreBackup();
        void removeBackup();

        bool createTables();
        void initDB();
        bool openDB();
        void closeDB();

        QSqlDatabase db;
        QString backupPath;
        QString filePath;
};

#endif
