#ifndef CONTROLLER_H
#define CONTROLLER_H

#include <QObject>
#include <QDate>
#include <QList>
#include <QSettings>
#include "expense.h"
#include "monthdata.h"
#include "mainwindow.h"
#include "dbmanager.h"
#include "concept.h"
#include "summarywindow.h"
#include "account.h"

class Controller : public QObject
{
        Q_OBJECT
 public:
        Controller();
        ~Controller();

 public slots:
        void previousMonth();
        void nextMonth();

        void newAccountSelected();
        void newAccountConfirmed(Account *a);
        void accountsSelected();
        void accountDetailsSelected(QModelIndex index);
        void deleteAccountConfirmed(Account *a);
        void updateAccountConfirmed(Account *a);
        void selectAccountConfirmed(Account *a);

        void newExpenseSelected();
        void newExpenseConfirmed(Expense *e);
        void expensesSelected();
        void expenseDetailsSelected(QModelIndex index);
        void deleteExpenseConfirmed(Expense *e);
        void updateExpenseConfirmed(Expense *e);

        void budgetSelected();
        void changeBudgetConfirmed(double budget);

        void conceptsSelected();
        void newConceptSelected();
        void conceptDetailsSelected(const QModelIndex &index);
        void newConceptConfirmed(Concept *c);
        void deleteConceptConfirmed(Concept *c);
        void updateConceptConfirmed(Concept *c);

        void scheduledSelected();
        void newScheduledSelected();
        void newScheduledConfirmed(Expense *e, bool createInCurrentMonth);
        void scheduledDetailsSelected(QModelIndex index);
        void deleteScheduledConfirmed(Expense *e);
        void updateScheduledConfirmed(Expense *e, bool createInCurrentMonth);

        void summarySelected();
        void summaryPeriodChanged(int startYear, int startMonth, int endYear, int endMonth);

 private:
        void loadMonth(bool reload = false);
        void loadConcepts();
        void loadScheduled();
        void loadAccounts();
        void createModelHeaders();

        MonthData *month;
        QDate date;
        MainWindow *mainWindow;
        DBManager db;
        QStandardItemModel *concepts;
        QStandardItemModel *scheduled;
        QStandardItemModel *accounts;
        QSettings *settings;
        SummaryWindow *summaryWindow;
        Account *activeAccount;
};

#endif
