#ifndef EXPENSE_H
#define EXPENSE_H

#include <QString>
#include <QObject>

class Expense : public QObject
{
 public:
        Expense(int id,
                int day,
                double amount,
                const QString &concept,
                const QString &description,
                int frecuency = 0);

        int id();
        int day();
        QString concept();
        QString description();
        double amount();
        void setAmount(double amount);
        void setId(int id);
        int frecuency();
        void addFrecuency(int frecuency);

        static QString frecuencyAsString(int frecuency);

 private:
        int _id;
        int _day;
        QString _concept;
        QString _description;
        double _amount;
        int _frecuency;
};

#endif 
