#include "summarydata.h"

SummaryData::SummaryData(int startYear,
                         int startMonth,
                         int endYear,
                         int endMonth)
{
        _startYear = startYear;
        _startMonth = startMonth;
        _endYear = endYear;
        _endMonth = endMonth;

        _totalBudget = 0;
        _totalExpense = 0;
        _totalSaved = 0;
        _maxExpense = 0;
        _minExpense = INT_MAX;
        _minSaved = INT_MAX;
        _maxSaved = 0;
        _monthCount = 0;
}

SummaryData::~SummaryData()
{
        foreach (Concept *concept, _concepts) {
                delete concept;
        }
}

int SummaryData::startYear()
{
        return _startYear;
}

int SummaryData::startMonth()
{
        return _startMonth;
}

int SummaryData::endYear()
{
        return _endYear;
}

int SummaryData::endMonth()
{
        return _endMonth;
}

void SummaryData::addMonthData(double budget, double expense)
{
        _totalBudget += budget;
        _totalExpense +=  expense;
        int saved = budget - expense;
        _totalSaved += saved;
        _monthCount ++;

        if (expense > _maxExpense) {
                _maxExpense = expense;
        }

        if (expense < _minExpense) {
                _minExpense = expense;
        }

        if (saved > _maxSaved) {
                _maxSaved = saved;
        }

        if (saved < _minSaved) {
                _minSaved = saved;
        }
}

double SummaryData::totalBudget()
{
        return _totalBudget;
}

double SummaryData::totalExpense()
{
        return _totalExpense;
}

double SummaryData::totalSaved()
{
        return _totalSaved;
}

double SummaryData::maxExpense()
{
        return _maxExpense;
}

double SummaryData::minExpense()
{
        return _minExpense;
}

double SummaryData::maxSaved()
{
        return _maxSaved;
}

double SummaryData::minSaved()
{
        return _minSaved;
}

double SummaryData::averageExpense()
{
        return _totalExpense/_monthCount;
}

double SummaryData::averageSaved()
{
        return _totalSaved/_monthCount;
}

void SummaryData::addConcept(Concept *c)
{
        _concepts.append(c);
}

const QList<Concept*>& SummaryData::concepts()
{
        return _concepts;
}
