#ifndef PERIODWINDOW_H
#define PERIODWINDOW_H

#include <QWidget>
#include <QModelIndex>
#include <QPushButton>
#include <QLabel>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QVBoxLayout>

class PeriodWindow : public QWidget
{
        Q_OBJECT
 public:
        PeriodWindow(int minYear,
                     int minMonth,
                     int maxYear,
                     int maxMonth,
                     QWidget *parent = 0);
        ~PeriodWindow();

 signals:
        void periodChanged(int startYear, int startMonth, int endYear, int endMonth);

 protected:
        QLabel *fromLabel;
        QLabel *toLabel;
        QVBoxLayout *vbox;

 private slots:
        void loadButtonClicked ();
        void startDateClicked ();
        void endDateClicked();
 private:
        int _minYear;
        int _minMonth;
        int _maxYear;
        int _maxMonth;
        int _startYear;
        int _startMonth;
        int _endYear;
        int _endMonth;
        QPushButton *loadButton;
        QMaemo5ValueButton *startDate;
        QMaemo5ValueButton *endDate;
};
#endif
