#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QWidget>
#include <QLineEdit>
#include <QPushButton>
#include <QLabel>
#include <QMouseEvent>
#include <QAction>
#include "monthdata.h"
#include "expensesgraph.h"

class MainWindow : public QWidget
{
        Q_OBJECT
 public:
        MainWindow(QWidget *parent=0);

        QSize minimumSizeHint() const;
        QSize sizeHint() const;

        void setMonthData (MonthData *data);

 protected:
        void mousePressEvent(QMouseEvent *event);
        void mouseReleaseEvent(QMouseEvent *event);

 signals:
        void previousMonth();
        void nextMonth();
        void addExpenseSelected();
        void accountsSelected();
        void budgetSelected();
        void conceptsSelected();
        void expensesSelected();
        void scheduledSelected();
        void summarySelected();

 private slots:
        void expensesChanged();
        void budgetChanged();

 private:
        void updateAll();
        void updateDateLabel();
        void updateBudgetLabel();
        void updateTotalLabel();
        void updateSavedLabel();
        void updateGraph();
        void updateAccountLabel();

        MonthData *month;
        ExpensesGraph *graph;
        QLabel *dateLabel;
        QLabel *budgetLabel;
        QLabel *totalLabel;
        QLabel *savedLabel;
        int pressXPosition;
        QAction *budgetAction;
        QAction *expensesAction;
        QAction *scheduledAction;
        QAction *summaryAction;
};
#endif
