#include "conceptsdialog.h"
#include <QHBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QListView>
#include <QPushButton>

ConceptsDialog::ConceptsDialog(QStandardItemModel *concepts,
                               QWidget *parent,
                               Qt::WindowFlags f)
        : QDialog (parent, f)
{
        setWindowTitle(tr("Items"));

        QHBoxLayout *layout = new QHBoxLayout (this);

        QListView *list = new QListView();
        list->setModel(concepts);
        list->setModelColumn(0);
        list->setProperty("FingerScrollable", true);
        layout->addWidget(list, 1);

        connect (list, SIGNAL(activated(const QModelIndex&)),
                 this, SLOT(detailsSelected(const QModelIndex&)));

        QDialogButtonBox *box = new QDialogButtonBox();
        box->addButton(new QPushButton(tr("New")), QDialogButtonBox::AcceptRole);
        box->addButton(QDialogButtonBox::Cancel);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(accepted()), this, SLOT(newSelected()));
        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
}

ConceptsDialog::~ConceptsDialog()
{
}

void ConceptsDialog::newSelected()
{
        accept();
        emit newConceptSelected();
}

void ConceptsDialog::detailsSelected(const QModelIndex &index)
{
        accept();
        emit conceptDetailsSelected(index);
}
