/**
    File: picasa_http.h
    
    Author: Tero Niemel

*/


#ifndef _PICASA_HTTP_H_
#define _PICASA_HTTP_H_

#include <curl/curl.h>


/**
   http_type_t
*/
typedef enum {
  POST = 0x01,
  GET = 0x02,
  PUT = 0x03
} http_type_t;

/**
   http_result_t
*/
typedef enum {
  HTTP_SUCCESS,
  HTTP_ERROR
} http_result_t;


/**
   http_request_state_t
*/
typedef enum {
  SENDING,
  DISCONNECTED,
  CANCELLED,
  ERROR
} http_request_state_t;

/**
   picasa_http_body_t
*/
typedef struct {
  GString *data;
  size_t sent;
} picasa_http_body_t;

/**
   http_request_t
*/
typedef struct {

  /* state of the request */
  http_request_state_t state;

  /* where to send the request */
  gchar *url;

  /* possible extra headers */
  struct curl_slist *hdr;

  /* post fields for normal HTTP post */
  struct curl_httppost *post;
  struct curl_httppost *last;
  
  /* write buffer and its max size */
  size_t  buf_size_max;
  GString *resp_buf;  

  /* curl progress callback and data */
  curl_progress_callback progress_cb;
  gpointer progress_data; 

  /* conic connection handle */
  ConIcConnection *con;

  /* possible read data */
  picasa_http_body_t read_data;

  /* total http body size */
  size_t body_size;
} http_request_t;


http_request_t 
*picasa_http_new (gchar *url);

http_result_t
picasa_http_append_read_data (http_request_t *request,
			      gchar *content);

http_result_t
picasa_http_add_header_data (http_request_t *request, 
			     gchar *name, gchar *value);

http_result_t
picasa_http_add_post_data (http_request_t *request, 
			   gchar *key, gchar *value);

http_result_t
picasa_http_add_post_data_with_type (http_request_t *request, 
				     gchar *value, gchar *type);

http_result_t
picasa_http_add_bin_file (http_request_t *request, 
			  const gchar *file, gchar *filename,
			  gchar *type);
http_result_t
picasa_http_send (http_request_t *request,
		  http_type_t type);

http_result_t
picasa_http_set_response_buffer (http_request_t *request, 
				 gint max_buf_size, GString *buf);

http_result_t
picasa_http_set_progress_cb (http_request_t *request, 
			     curl_progress_callback callback, gpointer data);

http_result_t
picasa_http_set_connection (http_request_t *request, 
			    ConIcConnection *con);

size_t 
picasa_http_print_http_post (http_request_t *request);

void 
picasa_http_free (http_request_t *request);


#endif /* _PICASA_HTTP_H_ */
