#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <stdlib.h>

#include <libhildondesktop/libhildondesktop.h>
#include <glib.h>
#include "s2cwidget.h"

HD_DEFINE_PLUGIN_MODULE (S2cPlugin, s2c_plugin,      HD_TYPE_HOME_PLUGIN_ITEM)
 
 
typedef struct _Data{
  
  
  gboolean started;
  GtkWidget *control;
  
}Data;


void
button_clicked (HildonButton *button, gpointer user_data)
{
  Data *self = (Data*)user_data;
  if(self->started)
  {
   system("killall shake2control"); 
   hildon_button_set_title(HILDON_BUTTON(self->control),"Start");
   self->started = FALSE;
  }
  else{
   system("/usr/bin/shake2control&");
   hildon_button_set_title(HILDON_BUTTON(self->control),"Stop");
   self->started = TRUE;
  }
  
}

 
static GtkWidget *
build_ui (void)
{
    GtkVBox *contents = GTK_VBOX (gtk_vbox_new (0, FALSE));
    GtkLabel *label = GTK_LABEL (gtk_label_new (" Shake2Control "));

    Data *self;
    self = g_new0(Data, 1);
    self->started = FALSE;
    self->control  = hildon_button_new_with_text(HILDON_SIZE_FINGER_HEIGHT,
                                        HILDON_BUTTON_ARRANGEMENT_VERTICAL,"Start",NULL);

    g_signal_connect (self->control, "clicked", G_CALLBACK (button_clicked), self);

    GtkHBox *buttons = GTK_HBOX (gtk_hbox_new (0, TRUE));
    gtk_container_add (GTK_CONTAINER (buttons), GTK_WIDGET (self->control));    
    gtk_box_pack_start (GTK_BOX (contents), GTK_WIDGET (label), FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (contents), GTK_WIDGET (buttons), FALSE, FALSE, 0);
    
    gtk_widget_show_all (GTK_WIDGET (contents)); 
      
    return GTK_WIDGET (contents);
}

static void
s2c_plugin_init (S2cPlugin *desktop_plugin)
{
  GtkWidget *contents = build_ui ();
  gtk_container_add (GTK_CONTAINER (desktop_plugin), contents);
} 

static void
s2c_plugin_class_init (S2cPluginClass *class) {} 

static void
s2c_plugin_class_finalize (S2cPluginClass *class) {} 
